<?php
namespace Viveum\Viveum\Block\Payment\Review;

use Magento\Sales\Model\Order\Address;

/**
 * Viveum easyCredit review details block
 */
class Details extends \Magento\Checkout\Block\Cart\Totals
{
    /**
     * @var Address
     */
    protected $_address;

    /**
     * Return review shipping address
     *
     * @return Address
     */
    public function getAddress()
    {
        if (empty($this->_address)) {
            $this->_address = $this->getQuote()->getShippingAddress();
        }
        return $this->_address;
    }

    /**
     * Return review quote totals
     *
     * @return array
     */
    public function getTotals()
    {
        return $this->getQuote()->getTotals();
    }
}
