<?php
namespace Viveum\Viveum\Block\Subscription;

use \Magento\Framework\View\Element\Template;
use \Magento\Framework\View\Element\Template\Context;

use \Viveum\Viveum\Model\Subscription\Subscription;
use \Viveum\Viveum\Model\ResourceModel\Subscription\Subscription\CollectionFactory as SubscriptionCollectionFactory;

class Index extends Template
{
    protected $customerSession;
    protected $subscriptionCollectionFactory = null;
    protected $moduleReader;
    protected $susbcription;
    protected $orderRepository;

    protected $_resource;
    private  $urlInterface;

    /**
     * @var \Psr\Log\LoggerInterface
     */
    private $logger;


    public function __construct(
        Context                                   $context,
        \Magento\Customer\Model\Session           $customerSession,
        SubscriptionCollectionFactory             $subscriptionCollectionFactory,
        \Magento\Framework\App\ResourceConnection $Resource,
        \Magento\Framework\Module\Dir\Reader $moduleReader,
        \Psr\Log\LoggerInterface $logger,
        \Magento\Framework\UrlInterface $urlInterface,
        \Viveum\Viveum\Model\Subscription\Subscription $subscription,
        \Magento\Sales\Api\OrderRepositoryInterface $orderRepository,
        array $data = []
        ) {
        $this->_subscriptionCollectionFactory = $subscriptionCollectionFactory;
        $this->_resource = $Resource;
        parent::__construct($context, $data);
        $this->subscriptionCollectionFactory = $subscriptionCollectionFactory;
        $this->resource = $Resource;
        $this->moduleReader = $moduleReader;
        $this->customerSession = $customerSession;
        $this->logger          = $logger;
        $this->urlInterface = $urlInterface;
        $this->susbcription = $subscription;
        $this->orderRepository = $orderRepository;
    }

    public function getSubscribs()
    {
        // get param values
        $page = ($this->getRequest()->getParam('p')) ? $this->getRequest()->getParam('p') : 1;
        $pageSize = ($this->getRequest()->getParam('limit')) ? $this->getRequest()->getParam('limit') : 10; // set minimum records

        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $customerSession = $objectManager->create("Magento\Customer\Model\Session");

        $subscribCollection = $this->subscriptionCollectionFactory->create();

        if($customerSession->isLoggedIn()){

            $customerId = $customerSession->getCustomerId();

            $subscribCollection->getSelect()->where("main_table.magento_user_id=".$customerId);
            $subscribCollection->setOrder('main_table.entity_id','DESC');

            $subscribCollection->setPageSize($pageSize);
            $subscribCollection->setCurPage($page);
        }

        return $subscribCollection;

    }

    /**
     * For a given subscrib, returns its url
     * @param Subscrib $subscrib
     * @return string
     */

    public function getSubscribUrl(
        Subscription $subscrib
    ) {
        return $this->urlInterface->getUrl() ."viveum/subscription/view/id/{$subscrib->getId()}";
    }

    /**
     * @inheritDoc
     */
    protected function _prepareLayout()
    {
        try{
            parent::_prepareLayout();
            if ($this->getSubscribs()) {
                $pager = $this->getLayout()->createBlock(
                    \Magento\Theme\Block\Html\Pager::class,
                    'viveum.subscription.index'
                )->setCollection(
                    $this->getSubscribs()
                );
                $this->setChild('pager', $pager);
                $this->getSubscribs()->load();
            }
            return $this;
       }catch(\Exception $e){
            $this->logger->info("Exception subscription paging: {$e->getMessage()}");
        }
    }

    /**
     * Get Pager child block output
     *
     * @return string
     */
    public function getPagerHtml()
    {
        return $this->getChildHtml('pager');
    }

    /**
     * For a given subscrib, returns its url
     * @param Subscrib $subscrib
     * @return string
     */
    public function unsubscribe(
        Subscription $subscrib
    ) {
        return $this->urlInterface->getUrl() ."viveum/subscription/unsubscribe/id/{$subscrib->getSubscriptionId()}";
    }

    public function getIncrementIdFromOrder($incrId){
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $collection = $objectManager->create('Magento\Sales\Model\Order');
        $orderInfo = $collection->loadByIncrementId($incrId);
        $orderId = $orderInfo->getId();
        return $orderId;
    }

    public function getUrlViewOrder($incrementId){
        return $this->urlInterface->getUrl().'sales/order/view/order_id/'.$this->getIncrementIdFromOrder($incrementId);
    }

}
