<?php
namespace Viveum\Viveum\Block\Subscription;

use \Magento\Framework\View\Element\Template;
use \Magento\Framework\View\Element\Template\Context;

use \Viveum\Viveum\Model\Subscription\Subscription;
use \Viveum\Viveum\Model\ResourceModel\Subscription\Subscription\CollectionFactory as SubscriptionCollectionFactory;
use \Viveum\Viveum\Model\ResourceModel\Subscription\SubscriptionPayment\CollectionFactory as SubscriptionPaymentCollectionFactory;

class View extends Template
{
    protected $customerSession;
    protected $subscriptionCollectionFactory = null;
    protected $subscriptionPaymentCollectionFactory = null;
    protected $moduleReader;
    protected $susbcription;

    protected $_resource;
    private  $urlInterface;

    /**
     * @var \Psr\Log\LoggerInterface
     */
    private $logger;


    public function __construct(
        Context                                   $context,
        \Magento\Customer\Model\Session           $customerSession,
        SubscriptionCollectionFactory             $subscriptionCollectionFactory,
        SubscriptionPaymentCollectionFactory      $subscriptionPaymentCollectionFactory,
        \Magento\Framework\App\ResourceConnection $Resource,
        \Magento\Framework\Module\Dir\Reader $moduleReader,
        \Psr\Log\LoggerInterface $logger,
        \Magento\Framework\UrlInterface $urlInterface,
        \Viveum\Viveum\Model\Subscription\Subscription $subscription,
        array $data = []
    ) {
        $this->_subscriptionCollectionFactory = $subscriptionCollectionFactory;
        $this->_resource = $Resource;
        parent::__construct($context, $data);
        $this->subscriptionCollectionFactory = $subscriptionCollectionFactory;
        $this->subscriptionPaymentCollectionFactory = $subscriptionPaymentCollectionFactory;
        $this->resource = $Resource;
        $this->moduleReader = $moduleReader;
        $this->customerSession = $customerSession;
        $this->logger          = $logger;
        $this->urlInterface = $urlInterface;
        $this->susbcription = $subscription;
    }


    public function getSubscrib()
    {
        // get param values
        $id = $this->getRequest()->getParam('id');

        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $customerSession = $objectManager->create("Magento\Customer\Model\Session");

        $subscribCollection = $this->subscriptionCollectionFactory->create();

        if($customerSession->isLoggedIn()){

            $customerId = $customerSession->getCustomerId();

            $subscribCollection->getSelect()->where("main_table.magento_user_id=".$customerId);

            $subscribCollection->addFieldToFilter('main_table.entity_id', $id);
            $singleData= $subscribCollection->getFirstItem();
            $data = $singleData->getData();
            return $data;
        }

        return $subscribCollection;
    }

    public function getSubscriptionPayments($transaction_id)
    {
        $subscriptionPaymentCollection = $this->subscriptionPaymentCollectionFactory->create();
        $subscriptionPaymentCollection->addFieldToFilter('main_table.transaction_id', $transaction_id);
        $subscriptionPaymentCollection->setOrder('main_table.created_at','DESC');

        $data = $subscriptionPaymentCollection->getData();
        return $data;
    }

    public function getIncrementIdFromOrder($incrId){
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $collection = $objectManager->create('Magento\Sales\Model\Order');
        $orderInfo = $collection->loadByIncrementId($incrId);
        $orderId = $orderInfo->getId();
        return $orderId;
    }

    public function getUrlViewOrder($incrementId){
        return $this->urlInterface->getUrl().'sales/order/view/order_id/'.$this->getIncrementIdFromOrder($incrementId);
    }

    /**
     * For a given subscrib, returns its url
     * @param Subscrib $subscrib
     * @return string
     */
    public function unsubscribe(
        $subscription_id
    ) {
        return $this->urlInterface->getUrl() ."viveum/subscription/unsubscribe/id/".$subscription_id;
    }

}
