<?php

namespace Viveum\Viveum\Controller\Adminhtml\Subscription;
use Exception;

class Unsubscribe extends \Magento\Backend\App\Action
{
    protected $_pageFactory;

    protected $plan;
    protected $subscription;
    protected $paymentHelper;
    protected $paymentMethod;
    private  $urlInterface;

    public function __construct(
        \Magento\Backend\App\Action\Context $context,
        \Magento\Framework\View\Result\PageFactory $pageFactory,
        \Viveum\Viveum\Model\Subscription\Plan $plan,
        \Viveum\Viveum\Model\Subscription\Subscription $subscription,
        \Magento\Framework\Message\ManagerInterface $messageManager,
        \Viveum\Viveum\Helper\Payment $paymentHelper,
        \Magento\Framework\UrlInterface $urlInterface
    )
    {
        $this->messageManager = $messageManager;
        $this->_pageFactory = $pageFactory;
        $this->plan = $plan;
        $this->subscription = $subscription;
        $this->paymentHelper = $paymentHelper;
        $this->urlInterface = $urlInterface;
        return parent::__construct($context);
    }

    private function createPaymentMethodObjectByPaymentMethod($payment_method)
    {
        if ($payment_method == 'viveum_paypalsaved') {
            $paymentMethodNameSpace = 'Viveum\Viveum\Model\Method\PaypalSaved';
        } else {
            $paymentMethodNameSpace = 'Viveum\Viveum\Model\Method\CCSaved';
        }

        return $this->_objectManager->create($paymentMethodNameSpace);
    }

    public function execute()
    {
        try{
            $subscriptionId = $this->getRequest()->getParam('id');
            $subscription = $this->subscription->getBySubscriptionId($subscriptionId);

            $this->paymentMethod = $this->createPaymentMethodObjectByPaymentMethod($subscription[0]['payment_method']);

            $deleteParameters = $this->paymentMethod->getCredentials();
            $deleteStatus = $this->paymentHelper->deSchedule($subscriptionId, $deleteParameters);

            if($deleteStatus['isValid']){
                $returnCode = $deleteStatus['response']['result']['code'];
                $errorMessage = $deleteStatus['response']['result']['description'];
                $errorIdentifier = $this->paymentHelper->getErrorIdentifier($returnCode);
                $transactionResult = $this->paymentHelper->getTransactionResult($returnCode);

                if ($errorIdentifier == 'ERROR_UNKNOWN' && !empty($errorMessage)) {
                    $errorIdentifier = $errorMessage;
                }

                if ($transactionResult == 'ACK') {

                    // update
                    $this->subscription->load($subscriptionId,'subscription_id')
                            ->setData('status', 'unsubscribed')
                            ->setData('cancel_by', 'administrator')
                            ->save();

                    $this->messageManager->addSuccessMessage(__("Unsubscribed successfully!"));

                } elseif ($transactionResult == 'NOK') {
                    $this->messageManager->addErrorMessage('Error when unsubscribe : '.$errorIdentifier);
                } else {
                    $this->messageManager->addErrorMessage('Error when unsubscribe : ERROR_UNKNOWN. Please contact administator');
                }
            } else {
                throw new Exception();
            }

        }catch(\Exception $e)
        {
            $this->messageManager->addErrorMessage(__('Error occured when unsubscribe this product. Please contact administator'));
        }

        $url = $this->urlInterface->getUrl('viveum/subscription/index');
        return $this->_redirect($url);
    }
}
