<?php

namespace Viveum\Viveum\Controller\Adminhtml\Subscription;

use \Magento\Framework\Registry;


class View extends \Magento\Backend\App\Action
{
    const REGISTRY_KEY_POST_ID = 'viveum_subscription_id';
    protected $resultPageFactory = false;

    /**
     * Core registry
     * @var Registry
     */
    protected $coreRegistry;

    public function __construct(
		\Magento\Backend\App\Action\Context $context,
		\Magento\Framework\View\Result\PageFactory $resultPageFactory,
        Registry $coreRegistry
	)
	{
		parent::__construct($context);
        $this->coreRegistry = $coreRegistry;
		$this->resultPageFactory = $resultPageFactory;
	}

	public function execute()
	{
        $this->coreRegistry->register(self::REGISTRY_KEY_POST_ID, $this->_request->getParam('id'));

        /** @var \Magento\Backend\Model\View\Result\Page $resultPage */
        $resultPage = $this->resultPageFactory->create();

		$resultPage->getConfig()->getTitle()->prepend((__('Subscription View')));
        $resultPage->setActiveMenu('Viveum_Viveum::subscription')
                    ->addBreadcrumb(__('Subscription'), __('Subscription'));
		return $resultPage;
	}
}
