<?php

namespace Viveum\Viveum\Controller\Subscription;

class Index extends \Magento\Framework\App\Action\Action
{
    protected $_pageFactory;

    protected $plan;
    protected $subscription;


    public function __construct(
        \Magento\Framework\App\Action\Context $context,
        \Magento\Framework\View\Result\PageFactory $pageFactory,
        \Viveum\Viveum\Model\Subscription\Plan $plan,
        \Viveum\Viveum\Model\Subscription\Subscription $subscription,
        \Magento\Framework\Message\ManagerInterface $messageManager
    )
    {
        $this->messageManager = $messageManager;
        $this->_pageFactory = $pageFactory;
        $this->plan = $plan;
        $this->subscription = $subscription;
        return parent::__construct($context);
    }


    public function execute()
    {

        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $customerSession = $objectManager->create("Magento\Customer\Model\Session");

        $customerId = $customerSession->getCustomerId();

        if (!$customerId) {
            $this->_redirect('customer/account/login');
        } else {
            $resultPage = $this->_pageFactory->create();
            return $resultPage;
        }
    }
}
