<?php

namespace Viveum\Viveum\Helper;

use \Datetime;

class Logger
{
    private $id;
    private $className;

	/**
     * @param string             $name       The logging channel
     * @param HandlerInterface[] $handlers   Optional stack of handlers
     * @param callable[]         $processors Optional array of processors
     */
    public function __construct($className = false) {
        $this->className = $className;

        if ( $className ) {
            $this->id = time() . rand(1111, 9999);
        }
    }

    private function write($logType, $msg, $value = '')
    {
        if ( !empty($value) ) {
            $msg .= ": " . json_encode($value);
        }
        $log_file_data = BP . '/var/log/viveum-' . date('d-m-Y') . '.log';

        if ( $this->className ) {
            $prefix = "(" . $this->id . ") " . $this->className;
            $msg = $prefix . " " . $msg;
        }

        $msg = $logType . " " . $msg;

        $date = new DateTime();
        $msg = "[" . $date->format('Y-m-d H:i:s.uP') . "] " . $msg;

        file_put_contents($log_file_data, $msg . "\n", FILE_APPEND);
    }

    /**
     * add info logging message
     *
     * @param string $logMessage
     * @param mix $value
     */
    public function info($logMessage, $value = '')
    {
        $this->write("INFO", $logMessage, $value);
    }

    /**
     * add errpr logging message
     *
     * @param string $logMessage
     * @param mix $value
     */
    public function error($logMessage, $value = '')
    {
        $this->write("ERROR", $logMessage, $value);
    }
}