<?php

namespace Viveum\Viveum\Helper;

class VersionTracker extends \Magento\Framework\App\Helper\AbstractHelper
{
    protected $trackerUrl = 'https://test.requestcatcher.com/';
    public $curl;
    public $logger;

    /**
     * [__construct description]
     * @param \Magento\Framework\App\Helper\Context       $context
     * @param \Viveum\Viveum\Helper\Logger                $logger
     * @param \Viveum\Viveum\Helper\Curl                  $curl
     */
    public function __construct(
        \Magento\Framework\App\Helper\Context $context,
        \Viveum\Viveum\Helper\Logger $logger,
        \Viveum\Viveum\Helper\Curl $curl
    ) {
        parent::__construct($context);
        $this->logger = $logger;
        $this->curl = $curl;
    }

    /**
     * Get the version tracker URL
     * @return string
     */
    protected function getTrackerUrl()
    {
        return $this->trackerUrl;
    }

    /**
     * Get the version tracker parameter
     * @param  array $postParameters
     * @return string
     */
    protected function setPostParametersToString($postParameters)
    {
        $postParameters['hash'] =
            md5($postParameters['shop_version'].
            $postParameters['plugin_version'].
            $postParameters['client']);

        return http_build_query(array_filter($postParameters), '', '&');
    }

    /**
     * Send the version tracker data into the API
     * @param  array $postParameters
     * @param  array $proxyParameters
     * @return void
     */
    public function send($postParameters, $proxyParameters)
    {
        $this->logger->info('start send to version tracker');
        $this->logger->info('get postParameters : ', $postParameters);
        $this->logger->info('get proxyParameters : ', $proxyParameters);

        $postData = $this->setPostParametersToString($postParameters);
        $this->logger->info('get postData : ', $postData);

        $url = $this->getTrackerUrl();
        $this->logger->info('get API url : ', $url);

        $response = $this->curl->getResponseData(
            $postData,
            $url,
            $proxyParameters['proxy'],
            $postParameters['transaction_mode']
        );
        $this->logger->info('get response from gateway : ', $response);

        return $response;
    }
}
