<?php
namespace Viveum\Viveum\Model\Method;

class Applepay extends AbstractMethod
{
    protected $_code= 'viveum_applepay';
    protected $brand = 'APPLEPAY';
    protected $methodTitle = 'FRONTEND_PM_APPLEPAY';

    /**
     * get a payment type
     * @return string
     */
    public function getPaymentType()
    {
        return $this->getPaymentTypeSelection();
    }

    /**
     * get logo overwrite
     * @return string
     */
    public function getLogo()
    {
        switch ($this->getConfigData('button_style')) {
            case 'white':
                return "applepay white.svg";
                break;
            case 'black':
                return "applepay black.svg";
                break;
            default:
                return "applepay white-with-line.svg";
                break;
        }
    }

}
