<?php
namespace Viveum\Viveum\Model\Method;

class DirectDebit extends \Viveum\Viveum\Model\Method\AbstractMethod
{
    protected $_code= 'viveum_directdebit';
    protected $brand = 'DIRECTDEBIT_SEPA';
    protected $methodTitle = 'FRONTEND_PM_DD';
    protected $logo = 'sepa.png';

    /**
     *
     * @param  \Magento\Quote\Api\Data\CartInterface|null $quote
     * @return boolean
     */
    public function isAvailable(\Magento\Quote\Api\Data\CartInterface $quote = null)
    {
        $isAvailable = parent::isAvailable($quote);

        if ($isAvailable) {

            $customerSession = $this->createCustomerSessionObject();
            if (!$this->isAdminLoggedIn() && ($this->isRecurring() && $customerSession->isLoggedIn())) {
                return false;
            }
        }

        return $isAvailable;
    }

    /**
     * get a payment type
     * @return string
     */
    public function getPaymentType()
    {
        return $this->getPaymentTypeSelection();
    }
}
