<?php
namespace Viveum\Viveum\Model\Method;

class Paypal extends \Viveum\Viveum\Model\Method\AbstractMethod
{
    protected $_code= 'viveum_paypal';
    protected $brand = 'PAYPAL';
    protected $methodTitle = 'FRONTEND_PM_PAYPAL';
    protected $logo = 'paypal.png';
    protected $isServerToServer = true;

    /**
     *
     * @param  \Magento\Quote\Api\Data\CartInterface|null $quote
     * @return boolean
     */
    public function isAvailable(\Magento\Quote\Api\Data\CartInterface $quote = null)
    {
        $isAvailable = parent::isAvailable($quote);

        if ($isAvailable) {

            $customerSession = $this->createCustomerSessionObject();
            if (!$this->isAdminLoggedIn() && ($this->isRecurring() && $customerSession->isLoggedIn())) {
                return false;
            }
        }

        return $isAvailable;
    }
}
