<?php

namespace Viveum\Viveum\Model;

use Magento\Checkout\Model\ConfigProviderInterface;
use Magento\Payment\Helper\Data as PaymentHelper;
use Magento\Framework\View\Asset\Repository;
use Magento\Framework\App\RequestInterface;

class PaymentConfigProvider implements ConfigProviderInterface
{
    protected $paymentHelper;

    protected $assetRepo;

    protected $request;

    protected $brands = [
        'VISA',
        'MASTER',
        'AMEX',
        'DINERS',
        'JCB'
    ];

    protected $methodCodes = [
        'viveum_ccsaved',
        'viveum_creditcard',
        'viveum_ddsaved',
        'viveum_directdebit',
        'viveum_giropay',
        'viveum_paypal',
        'viveum_paypalsaved',
        'viveum_klarnaobt',
        'viveum_googlepay',
        'viveum_applepay',
        'viveum_eps',
    ];

    protected $methods = [];

    /**
     *
     * @param PaymentHelper    $paymentHelper
     * @param Repository       $assetRepo
     * @param RequestInterface $request
     */
    public function __construct(
        PaymentHelper $paymentHelper,
        Repository $assetRepo,
        RequestInterface $request
    ) {
        $this->paymentHelper = $paymentHelper;
        $this->assetRepo = $assetRepo;
        $this->request = $request;

        foreach ($this->methodCodes as $code) {
            $this->methods[$code] = $this->paymentHelper->getMethodInstance($code);
        }
    }

    /**
     * get configurations
     * @return [type]
     */
    public function getConfig()
    {
        $config = [];
        $configErrorEasyCredit = [];
        $mConfig = [];
        foreach ($this->methodCodes as $code) {
            if ($this->methods[$code]->isAvailable()) {
                if ($code == 'viveum_ccsaved' || $code == 'viveum_creditcard') {
                    $selectedBrands = explode(' ', $this->methods[$code]->getBrand());
                    foreach ($this->brands as $brand) {
                        if (in_array($brand, $selectedBrands)) {
                            $display = 'block';
                        } else {
                            $display = 'none';
                        }
                        $asset = $this->createAsset(
                            'Viveum_Viveum::images/' . strtolower($brand) . '.png'
                        );
                        $config['payment']['viveum']['logos'][$code][$brand] = [
                            'url' => $asset->getUrl(),
                            'height' => '35px',
                            'display' => $display
                        ];
                    }
                } else {
                    if ($code == 'viveum_klarnapaylater') {
                        $config['payment']['viveum']['logos'][$code] = $this->setMethodImage($code);
                        $mConfig = $this->setMethodConfig($code);
                    } elseif ($code == 'viveum_klarnasliceit') {
                        $config['payment']['viveum']['logos'][$code] = $this->setMethodImage($code);
                        $mConfig = $this->setMethodConfig($code);
                        $config['payment']['viveum']['details'][$code]['flexible'] =
                            __('FRONTEND_TT_KLARNASLICEIT_FLEXIBEL');
                        $pClass = $this->methods[$code]->getPClassWithCalcMonthlyCost();
                        $config['payment']['viveum']['details'][$code]['interest'] =
                            __('FRONTEND_TT_KLARNASLICEIT_INTEREST', $pClass['interestRate']);
                        $config['payment']['viveum']['details'][$code]['monthlyFee'] =
                            __('FRONTEND_TT_KLARNASLICEIT_MONTHLY_FEE', $pClass['invoiceFee']);
                        $config['payment']['viveum']['details'][$code]['monthlyPay'] =
                            __('FRONTEND_TT_KLARNASLICEIT_MONTHLY_PAY', $pClass['calcMonthlyCost']);
                    } elseif ($code == 'viveum_easycredit') {
                        $config['payment']['viveum']['logos'][$code] = $this->setMethodImage($code);
                        $mConfig = $this->setMethodConfig($code);
                        $configErrorEasyCredit = $this->setConfigErrorEasyCredit($code);
                        $shopName = $this->methods[$code]->getConfigData('shop_name');
                        $config['payment']['viveum']['details'][$code]['easycreditTerms'] =
                            str_replace(
                                "%x",
                                $shopName,
                                __('EASYCREDIT_FRONTEND_TERMS')
                            );
                        $config['payment']['viveum']['details'][$code]['easycreditTermError'] = __("ERROR_MESSAGE_EASYCREDIT_REQUIRED");
                    } elseif ($code == 'viveum_paypalsaved') {
                        $config['payment']['viveum']['logos'][$code] = $this->setMethodImage($code);
                        $config['payment']['viveum']['details'][$code]['userConsent'] = __('I would like to save my PayPal data');
                        $config['payment']['viveum']['details'][$code]['userConsentError'] = __('Please save your PayPal data');
                    } else {
                        $config['payment']['viveum']['logos'][$code] = $this->setMethodImage($code);
                    }
                }
            }
        }
        $config = array_merge_recursive($config, $configErrorEasyCredit, $mConfig);

        return $config;
    }

    public function setMethodImage($code)
    {
        $asset = $this->createAsset('Viveum_Viveum::images/' . $this->methods[$code]->getLogo());
        $config = [
            'url' => $asset->getUrl(),
            'height' => '35px',
            'display' => 'block'
        ];

        return $config;
    }

    public function setMethodConfig($code)
    {
        $config['payment']['viveum']['details'][$code]['merchantId'] =
            $this->methods[$code]->getConfigData('merchant_id');
        $config['payment']['viveum']['details'][$code]['term1'] = __('FRONTEND_TT_KLARNA_TERM1');
        $config['payment']['viveum']['details'][$code]['term2'] = __('FRONTEND_TT_KLARNA_TERM2');
        $config['payment']['viveum']['details'][$code]['addressError']
            = __('ERROR_MESSAGE_BILLING_SHIPPING_NOTSAME');
        $config['payment']['viveum']['details'][$code]['termError']
            = __('ERROR_MESSAGE_KLARNA_REQUIRED');
        $config['payment']['viveum']['details'][$code]['easycreditConfirm'] =
            __('FRONTEND_EASYCREDIT_CONFIRM_BUTTON');

        return $config;
    }

    /**
     * create an asset
     * @param  string $fileId
     * @param  array  $params
     * @return object
     */
    public function createAsset($fileId, array $params = [])
    {
        $params = array_merge(['_secure' => $this->request->isSecure()], $params);
        return $this->assetRepo->createAsset($fileId, $params);
    }

    public function setConfigErrorEasyCredit($code)
    {
        $config['payment']['viveum']['details'][$code]['errorDoB'] = __('');
        $config['payment']['viveum']['details'][$code]['errorGender'] = __('');
        $config['payment']['viveum']['details'][$code]['errorAmount'] =
            "* " . __('ERROR_MESSAGE_EASYCREDIT_AMOUNT_NOTALLOWED');

        $errorGender = $this->methods[$code]->easyCreditGetGenderStatusError();

        if ($errorGender != '') {
            $config['payment']['viveum']['details'][$code]['errorGender'] =
                "* " . __('ERROR_MESSAGE_EASYCREDIT_PARAMETER_GENDER');
        }
        $config['payment']['viveum']['details'][$code]['addressErrorEasyCredit'] =
            "* " . __('ERROR_EASYCREDIT_BILLING_NOTEQUAL_SHIPPING');
        $config['payment']['viveum']['details'][$code]['genderFemale'] = __('FRONTEND_GENDER_FEMALE');
        $config['payment']['viveum']['details'][$code]['genderMale'] = __('FRONTEND_GENDER_MALE');

        return $config;
    }
}
