<?php
namespace Viveum\Viveum\Model\Subscription;

class Plan extends \Magento\Framework\Model\AbstractModel
{
    /**
     * Define resource model
     */
    protected function _construct()
    {
        $this->_init('Viveum\Viveum\Model\ResourceModel\Subscription\Plan');
    }

    public function getAllPlans()
    {
        $planCollection = $this->getCollection();
        return $planCollection->getData();
    }

    public function getEnableStatus() {
        return 1;
    }

    public function getDisableStatus() {
        return 0;
    }

    public function getAvailableStatuses() {
        return [
            $this->getEnableStatus() => __('Enabled'),
            $this->getDisableStatus() => __('Disabled'),
        ];
    }

}
