<?php
namespace Viveum\Viveum\Model\Subscription;

class SubscriptionPayment extends \Magento\Framework\Model\AbstractModel
{
    /**
     * Define resource model
     */
    protected function _construct()
    {
        $this->_init('Viveum\Viveum\Model\ResourceModel\Subscription\SubscriptionPayment');
    }

    public function getAllPayments()
    {
        $collection = $this->getCollection();
        return $collection->getData();
    }

    public function insertPayment($parameters)
    {
        try{
            $this->setData ('subscription_id', $parameters['subscription_id']);
            $this->setData ('transaction_id', $parameters['transaction_id']);
            $this->setData ('payment_id', $parameters['payment_id']);
            $this->setData ('from_webhook', $parameters['from_webhook']);
            $this->setData ('amount', $parameters['amount']);
            $this->setData ('status', $parameters['status']);
            $this->setData ('created_at', date("Y-m-d h:i:sa"));
            $this->save();

            return true;
        }catch(\Exception $e)
        {
            return false;
        }
    }
}
