<?php

namespace Viveum\Viveum\Observer;

use Magento\Checkout\Model\Cart;
use Magento\Framework\Event\Observer;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Message\ManagerInterface;
use Magento\Catalog\Model\Product;
use Psr\Log\LoggerInterface;
use Viveum\Viveum\Helper\Subscription;

class RestrictRecurringProductToCartObserver implements ObserverInterface
{
    /**
     * @var ManagerInterface
     */
    private $messageManager;

    /**
     * @var Cart
     */
    private $cart;

    /**
     * @var LoggerInterface
     */
    private $logger;

    /**
     * @var Product
     */
    private $product;

    /**
     * @var Subscription
     */
    private $subscriptionHelper;

    private $paymentType;

    public function __construct(
        ManagerInterface $messageManager,
        Cart  $cart,
        Product $product,
        LoggerInterface $logger,
        Subscription $subscriptionHelper
    )
    {
        $this->messageManager = $messageManager;
        $this->cart = $cart;
        $this->logger = $logger;
        $this->product = $product;
        $this->subscriptionHelper = $subscriptionHelper;
    }

    public function execute(Observer $observer)
    {
        $cartItemsCount = $this->cart->getQuote()->getItemsCount();
        $allCartItems = $this->cart->getQuote()->getAllItems();

        $productId = $observer->getRequest()->getParam('product');
        $product = $this->product->load($productId);
        $this->paymentType = $observer->getRequest()->getParam('paymentOption');

        if($product->getViveumSubscriptionEnabled() && empty($this->paymentType)){
            $observer->getRequest()->setParam('product', false);
            $message = 'This product is subscription products, please select subscription plan first';
            return $this->messageManager->addErrorMessage(__($message));
        }

        if ($cartItemsCount >= 1) {
            if ($this->paymentType == "subscription") {
                $message = $this->verifySubscription($allCartItems, $cartItemsCount);
            } else{
                $message = $this->verifyRegular($allCartItems, $cartItemsCount);
            }

            if (!empty($message)) {
                $observer->getRequest()->setParam('product', false);
                return $this->messageManager->addErrorMessage(__($message));
            }
        }
    }

    /**
     * @param $allCartItems
     * @param $cartItemsCount
     * @param $validateTo
     * @return string
     */
    private function verifySubscription($allCartItems, $cartItemsCount): string
    {
        $message = "";
        if($this->subscriptionHelper->validateRegularProduct($allCartItems)){
            $message = "You cannot have regular products and subscriptions product in your shopping cart";
        } else if($cartItemsCount >= 1 && $this->paymentType == "subscription") {
            $message = "You cannot have regular products and subscriptions product and only can have one susbcription product in your shopping cart.";
        }
        return $message;
    }

    private function verifyRegular($allCartItems, $cartItemsCount): string
    {
        $message = "";
        if($this->subscriptionHelper->validateSubscription($allCartItems)){
            $message = "You cannot have regular products and subscriptions product in your shopping cart";
        } else if($cartItemsCount >= 1 && $this->paymentType == "subscription") {
            $message = "You cannot have regular products and subscriptions product and only can have one susbcription product in your shopping cart.";
        }
        return $message;
    }

}
