<?php
namespace Viveum\Viveum\Observer;

use Magento\Framework\Event\ObserverInterface;

class SubmitSuccessObserver implements ObserverInterface
{
	protected $authSession;

    /**
     *
     * @param \Magento\Backend\Model\Auth\Session $authSession
     */
    public function __construct(
        \Magento\Backend\Model\Auth\Session $authSession
    ) {
        $this->authSession = $authSession;
    }

    /**
     *
     * @param  \Magento\Framework\Event\Observer $observer
     * @return void
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
    	$isAdminLoggedIn =  $this->authSession->isLoggedIn();
    	if (!$isAdminLoggedIn) {
            $quote = $observer->getEvent()->getQuote();
            $paymentMethod = $quote->getPayment()->getMethod();
            if (strpos($paymentMethod, 'viveum') !== false) {
                if ($paymentMethod !== 'viveum_easycredit') {
        	        $quote->setIsActive(true);
        	        $quote->setReservedOrderId(null);
                }
            }
	    }
    }
}
