<?php

namespace Viveum\Viveum\Setup;

use Magento\Catalog\Model\Product;
use Magento\Eav\Setup\EavSetupFactory;
use Magento\Framework\Setup\UpgradeDataInterface;
use Magento\Framework\Setup\ModuleDataSetupInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Viveum\Viveum\Model\SubscriptionProductOptions;

class UpgradeData implements UpgradeDataInterface
{
    private $eavSetupFactory;
    private $eavTypeFactory;
    private $attributeSetFactory;
    private $groupCollectionFactory;

    public function __construct(
        \Magento\Eav\Model\Entity\TypeFactory $eavTypeFactory,
        \Magento\Eav\Model\Entity\Attribute\SetFactory $attributeSetFactory,
        \Magento\Eav\Model\ResourceModel\Entity\Attribute\Group\CollectionFactory $groupCollectionFactory,
        EavSetupFactory $eavSetupFactory)
    {
        $this->eavSetupFactory = $eavSetupFactory;
        $this->eavTypeFactory = $eavTypeFactory;
        $this->attributeSetFactory = $attributeSetFactory;
        $this->groupCollectionFactory = $groupCollectionFactory;
    }

    public function upgrade(
        ModuleDataSetupInterface $setup,
        ModuleContextInterface $context
    ) {
        $setup->startSetup();
        $installer = $setup;
        $tableName = array(
                'core_config_data',
                'quote_payment',
                'sales_invoice_grid',
                'sales_order_grid',
                'sales_order_payment'
            );

        if (version_compare($context->getVersion(), '2.0.08', '<')) {

            $oldCoreConfigData = array(
                        'payment/viveum_klarnainv/active',
                        'payment/viveum_klarnainv/server_mode',
                        'payment/viveum_klarnainv/channel_id',
                        'payment/viveum_klarnainv/merchant_id',
                        'payment/viveum_klarnainv/allowspecific',
                        'payment/viveum_klarnainv/sort_order',
                        'payment/viveum_klarnains/active',
                        'payment/viveum_klarnains/server_mode',
                        'payment/viveum_klarnains/channel_id',
                        'payment/viveum_klarnains/merchant_id',
                        'payment/viveum_klarnains/shared_secret',
                        'payment/viveum_klarnains/currency',
                        'payment/viveum_klarnains/country',
                        'payment/viveum_klarnains/language',
                        'payment/viveum_klarnains/pclass_id',
                        'payment/viveum_klarnains/description',
                        'payment/viveum_klarnains/pclass_months',
                        'payment/viveum_klarnains/pclass_start_fee',
                        'payment/viveum_klarnains/pclass_invoice_fee',
                        'payment/viveum_klarnains/pclass_interest_rate',
                        'payment/viveum_klarnains/pclass_minimum_purchase',
                        'payment/viveum_klarnains/pclass_country',
                        'payment/viveum_klarnains/pclass_type',
                        'payment/viveum_klarnains/pclass_expiry_date',
                        'payment/viveum_klarnains/allowspecific',
                        'payment/viveum_klarnains/sort_order',
                        'payment/viveum_sofortuberweisung/active',
                        'payment/viveum_sofortuberweisung/server_mode',
                        'payment/viveum_sofortuberweisung/channel_id',
                        'payment/viveum_sofortuberweisung/allowspecific',
                        'payment/viveum_sofortuberweisung/sort_order'
                );

            $newCoreConfigData = array(
                        'payment/viveum_klarnapaylater/active',
                        'payment/viveum_klarnapaylater/server_mode',
                        'payment/viveum_klarnapaylater/channel_id',
                        'payment/viveum_klarnapaylater/merchant_id',
                        'payment/viveum_klarnapaylater/allowspecific',
                        'payment/viveum_klarnapaylater/sort_order',
                        'payment/viveum_klarnasliceit/active',
                        'payment/viveum_klarnasliceit/server_mode',
                        'payment/viveum_klarnasliceit/channel_id',
                        'payment/viveum_klarnasliceit/merchant_id',
                        'payment/viveum_klarnasliceit/shared_secret',
                        'payment/viveum_klarnasliceit/currency',
                        'payment/viveum_klarnasliceit/country',
                        'payment/viveum_klarnasliceit/language',
                        'payment/viveum_klarnasliceit/pclass_id',
                        'payment/viveum_klarnasliceit/description',
                        'payment/viveum_klarnasliceit/pclass_months',
                        'payment/viveum_klarnasliceit/pclass_start_fee',
                        'payment/viveum_klarnasliceit/pclass_invoice_fee',
                        'payment/viveum_klarnasliceit/pclass_interest_rate',
                        'payment/viveum_klarnasliceit/pclass_minimum_purchase',
                        'payment/viveum_klarnasliceit/pclass_country',
                        'payment/viveum_klarnasliceit/pclass_type',
                        'payment/viveum_klarnasliceit/pclass_expiry_date',
                        'payment/viveum_klarnasliceit/allowspecific',
                        'payment/viveum_klarnasliceit/sort_order',
                        'payment/viveum_klarnaobt/active',
                        'payment/viveum_klarnaobt/server_mode',
                        'payment/viveum_klarnaobt/channel_id',
                        'payment/viveum_klarnaobt/allowspecific',
                        'payment/viveum_klarnaobt/sort_order'

                );

            $olQuotePayment = array(
                'viveum_klarnainv',
                'viveum_klarnains',
                'viveum_sofortuberweisung'
            );

            $newQuotePayment = array(
                'viveum_klarnapaylater',
                'viveum_klarnasliceit',
                'viveum_klarnaobt'
            );

            $oldSalesInvoiceGrid = array(
                'viveum_klarnainv',
                'viveum_klarnains',
                'viveum_sofortuberweisung'
            );

            $newSalesInvoiceGrid = array(
                'viveum_klarnapaylater',
                'viveum_klarnasliceit',
                'viveum_klarnaobt'
            );

            $oldSalesOrderGrid = array(
                'viveum_klarnainv',
                'viveum_klarnains',
                'viveum_sofortuberweisung'
            );

            $newSalesOrderGrid = array(
                'viveum_klarnapaylater',
                'viveum_klarnasliceit',
                'viveum_klarnaobt'
            );

            $oldSalesOrderPayment = array(
                'viveum_klarnainv',
                'viveum_klarnains',
                'viveum_sofortuberweisung'
            );

            $newSalesOrderPayment = array(
                'viveum_klarnapaylater',
                'viveum_klarnasliceit',
                'viveum_klarnaobt'
            );

            foreach (array_combine($oldCoreConfigData, $newCoreConfigData) as $old => $new) {
                $installer->updateTableRow(
                    $installer->getTable('core_config_data'),
                    'path',
                    $old,
                    'path',
                    $new
                );
            }

            foreach (array_combine($olQuotePayment, $newQuotePayment) as $old => $new) {
                $installer->updateTableRow(
                    $installer->getTable('quote_payment'),
                    'method',
                    $old,
                    'method',
                    $new
                );
            }

            foreach (array_combine($oldSalesInvoiceGrid, $newSalesInvoiceGrid) as $old => $new) {
                $installer->updateTableRow(
                    $installer->getTable('sales_invoice_grid'),
                    'payment_method',
                    $old,
                    'payment_method',
                    $new
                );
            }

            foreach (array_combine($oldSalesOrderGrid, $newSalesOrderGrid) as $old => $new) {
                $installer->updateTableRow(
                    $installer->getTable('sales_order_grid'),
                    'payment_method',
                    $old,
                    'payment_method',
                    $new
                );
            }

            foreach (array_combine($oldSalesOrderPayment, $newSalesOrderPayment) as $old => $new) {
                $installer->updateTableRow(
                    $installer->getTable('sales_order_payment'),
                    'method',
                    $old,
                    'method',
                    $new
                );
            }
        }

        $this->installEntities($setup);
        $setup->endSetup();
    }

    public function installEntities($setup)
    {
        $groupName = 'Viveum Subscriptions';

        $attributes = [
            'viveum_subscription_enabled' => [
                'type' => 'int',
                'label' => 'Subscription Enabled',
                'input' => 'boolean',
                'source' => 'Magento\Eav\Model\Entity\Attribute\Source\Boolean',
                'sort_order' => 100,
                'global' => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_STORE,
                'group' => $groupName,
                'is_used_in_grid' => true,
                'is_visible_in_grid' => true,
                'is_filterable_in_grid' => true,
                'required' => false
            ],
            'viveum_subscription_daily_enabled' => [
                'type' => 'int',
                'label' => 'Daily',
                'input' => 'boolean',
                'source' => 'Magento\Eav\Model\Entity\Attribute\Source\Boolean',
                'sort_order' => 101,
                'global' => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_STORE,
                'group' => $groupName,
                'is_used_in_grid' => false,
                'is_visible_in_grid' => false,
                'is_filterable_in_grid' => false,
                'required' => false
            ],
            'viveum_subscription_weekly_enabled' => [
                'type' => 'int',
                'label' => 'Weekly',
                'input' => 'boolean',
                'source' => 'Magento\Eav\Model\Entity\Attribute\Source\Boolean',
                'sort_order' => 103,
                'global' => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_STORE,
                'group' => $groupName,
                'is_used_in_grid' => false,
                'is_visible_in_grid' => false,
                'is_filterable_in_grid' => false,
                'required' => false
            ],
            'viveum_subscription_monthly_enabled' => [
                'type' => 'int',
                'label' => 'Monthly',
                'input' => 'boolean',
                'source' => 'Magento\Eav\Model\Entity\Attribute\Source\Boolean',
                'sort_order' => 105,
                'global' => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_STORE,
                'group' => $groupName,
                'is_used_in_grid' => false,
                'is_visible_in_grid' => false,
                'is_filterable_in_grid' => false,
                'required' => false
            ],
            'viveum_subscription_yearly_enabled' => [
                'type' => 'int',
                'label' => 'Yearly',
                'input' => 'boolean',
                'source' => 'Magento\Eav\Model\Entity\Attribute\Source\Boolean',
                'sort_order' => 107,
                'global' => \Magento\Eav\Model\Entity\Attribute\ScopedAttributeInterface::SCOPE_STORE,
                'group' => $groupName,
                'is_used_in_grid' => false,
                'is_visible_in_grid' => false,
                'is_filterable_in_grid' => false,
                'required' => false
            ],
        ];

        $eavSetup = $this->eavSetupFactory->create(['setup' => $setup]);

        foreach ($attributes as $attributeCode => $attribute){
            $eavSetup->addAttribute(Product::ENTITY, $attributeCode, $attribute);
        }

        $eavSetup->removeAttribute(Product::ENTITY, 'viveum_subscription_daily_charge');
        $eavSetup->removeAttribute(Product::ENTITY, 'viveum_subscription_weekly_charge');
        $eavSetup->removeAttribute(Product::ENTITY, 'viveum_subscription_monthly_charge');
        $eavSetup->removeAttribute(Product::ENTITY, 'viveum_subscription_yearly_charge');


        $this->sortGroup($groupName,11);
    }

    private function sortGroup($attributeGroupName, $order)
    {
        $entityType = $this->eavTypeFactory->create()->loadByCode('catalog_product');
        $setCollection = $this->attributeSetFactory->create()->getCollection();
        $setCollection->addFieldToFilter('entity_type_id', $entityType->getId());

        foreach ($setCollection as $attributeSet)
        {
            $this->groupCollectionFactory->create()
                ->addFieldToFilter('attribute_set_id', $attributeSet->getId())
                ->addFieldToFilter('attribute_group_name', $attributeGroupName)
                ->getFirstItem()
                ->setSortOrder($order)
                ->save();
        }

        return true;
    }
}
