<?php
namespace Viveum\Viveum\Setup;

use Magento\Framework\Setup\UpgradeSchemaInterface;
use Magento\Framework\Setup\ModuleContextInterface;
use Magento\Framework\Setup\SchemaSetupInterface;

class UpgradeSchema implements UpgradeSchemaInterface
{
    public function upgrade( SchemaSetupInterface $setup, ModuleContextInterface $context ) {
        $installer = $setup;

        $installer->startSetup();

        if(version_compare($context->getVersion(), '2.0.6', '<')) {
            $installer->getConnection()->addColumn(
                $installer->getTable( 'viveum_payment_information' ),
                'initial_transaction_id',
                [
                    'type' => \Magento\Framework\DB\Ddl\Table::TYPE_TEXT,
                    'nullable' => true,
                    'length' => '32',
                    'comment' => 'Initial Transaction Id',
                    'after' => 'registration_id'
                ]
            );
        }

        $installer->endSetup();
    }
}
