<?php
namespace Viveum\Viveum\Ui\Listing;

use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;
use Magento\Framework\UrlInterface;

class SubscriptionActions extends Column
{
    /**
     * @var UrlInterface
     */
    private $urlBuilder;

    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        UrlInterface $urlBuilder,
        array $components = array(),
        array $data = array())
    {
        parent::__construct($context, $uiComponentFactory, $components, $data);
        $this->urlBuilder = $urlBuilder;
    }

    /**
     * Prepare Data Source
     *
     * @param array $dataSource
     * @return void
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as & $item) {
                $name = $this->getData('name');
                if (isset($item['subscription_id'])) {
                    $item[$name]['view'] = [
                        'href' => $this->urlBuilder->getUrl('viveum/subscription/view', ['id' => strip_tags($item['subscription_id'])]),
                        'label' => __('View'),
                        '__disableTmpl' => true,
                    ];
                }

                if(strtolower($item['status']) == 'active'){
                    $item[$name]['cancel'] = [
                        'href' => $this->urlBuilder->getUrl('viveum/subscription/unsubscribe', ['id' => strip_tags($item['subscription_id'])]),
                        'label' => __('Unsubscribe'),
                        'confirm' => [
                            'title' => __('Cancel Subscription'),
                            'message' => __('Are you sure you want to cancel a subscription?'),
                            '__disableTmpl' => true,
                        ],
                        'post' => true,
                        '__disableTmpl' => true,
                    ];
                }

            }
        }

        return $dataSource;
    }
}
