<?php
namespace Viveum\Viveum\Ui\Listing;

use Magento\Framework\View\Element\UiComponent\ContextInterface;
use Magento\Framework\View\Element\UiComponentFactory;
use Magento\Ui\Component\Listing\Columns\Column;
use Magento\Framework\UrlInterface;

class SubscriptionView extends Column
{
    /**
     * @var UrlInterface
     */
    private $urlBuilder;

    public function __construct(
        ContextInterface $context,
        UiComponentFactory $uiComponentFactory,
        UrlInterface $urlBuilder,
        array $components = array(),
        array $data = array())
    {
        parent::__construct($context, $uiComponentFactory, $components, $data);
        $this->urlBuilder = $urlBuilder;
    }

    public function getIncrementIdFromOrder($incrId){
        $objectManager = \Magento\Framework\App\ObjectManager::getInstance();
        $collection = $objectManager->create('Magento\Sales\Model\Order');
        $orderInfo = $collection->loadByIncrementId($incrId);
        $orderId = $orderInfo->getId();
        return $orderId;
    }

    /**
     * Prepare Data Source
     *
     * @param array $dataSource
     * @return void
     */
    public function prepareDataSource(array $dataSource)
    {
        if (isset($dataSource['data']['items'])) {
            foreach ($dataSource['data']['items'] as &$item) {
                $name = $this->getData('name');
                if($name == 'subscription_id'){
                    $item[$name] = html_entity_decode('<a href="'.$this->urlBuilder->getUrl('viveum/subscription/view', ['id' => $item['subscription_id']]).'">'.$item['subscription_id'].'</a>');
                }

                if($name == 'transaction_id'){
                    $id = $this->getIncrementIdFromOrder($item['transaction_id']);
                    $item[$name] = html_entity_decode('<a href="'.$this->urlBuilder->getUrl('sales/order/view', ['order_id' => $id]).'">'.$item['transaction_id'].'</a>');
                }

                if($name == 'firstname'){
                    $item[$name] = $item['customer_firstname'].' '.$item['customer_lastname'];
                }

                if($name == 'plan_id' || $name == 'status'){
                    $item[$name] = ucfirst($item[$name]);
                }


            }
        }

        return $dataSource;
    }
}
