<?php
namespace Viveum\Viveum\Block\Adminhtml\Subscription;

use \Magento\Framework\View\Element\Template;
use \Magento\Framework\View\Element\Template\Context;
use Viveum\Viveum\Controller\Adminhtml\Subscription\View as ViewAction;
use \Viveum\Viveum\Model\Subscription\Subscription;
use \Viveum\Viveum\Model\ResourceModel\Subscription\Subscription\CollectionFactory as SubscriptionCollectionFactory;
use \Viveum\Viveum\Model\ResourceModel\Subscription\SubscriptionPayment\CollectionFactory as SubscriptionPaymentCollectionFactory;
use \Magento\Framework\Registry;

class View extends Template
{
    /**
     * @var Context
     */
    protected $context;

    /**
     * Core registry
     * @var Registry
     */
    protected $coreRegistry;

    protected $customerSession;
    protected $subscriptionCollectionFactory = null;
    protected $subscriptionPaymentCollectionFactory = null;
    protected $moduleReader;
    protected $susbcription;

    protected $_resource;
    private  $urlInterface;

    /**
     * @var \Psr\Log\LoggerInterface
     */
    private $logger;


    public function __construct(
        Context                                   $context,
        \Magento\Customer\Model\Session           $customerSession,
        SubscriptionCollectionFactory             $subscriptionCollectionFactory,
        SubscriptionPaymentCollectionFactory      $subscriptionPaymentCollectionFactory,
        \Magento\Framework\App\ResourceConnection $Resource,
        \Magento\Framework\Module\Dir\Reader $moduleReader,
        \Psr\Log\LoggerInterface $logger,
        \Magento\Framework\UrlInterface $urlInterface,
        \Viveum\Viveum\Model\Subscription\Subscription $subscription,
        Registry $coreRegistry,
        array $data = []
    ) {
        $this->context = $context;
        $this->_subscriptionCollectionFactory = $subscriptionCollectionFactory;
        $this->_resource = $Resource;
        $this->coreRegistry = $coreRegistry;

        parent::__construct($context, $data);
        $this->subscriptionCollectionFactory = $subscriptionCollectionFactory;
        $this->subscriptionPaymentCollectionFactory = $subscriptionPaymentCollectionFactory;
        $this->resource = $Resource;
        $this->moduleReader = $moduleReader;
        $this->customerSession = $customerSession;
        $this->logger          = $logger;
        $this->urlInterface = $urlInterface;
        $this->susbcription = $subscription;

    }


    public function getSubscrib()
    {

        $subscribCollection = $this->subscriptionCollectionFactory->create();

        $second_table_name = $this->_resource->getTableName('catalog_product_entity_varchar');
        $third_table_name = $this->_resource->getTableName('eav_attribute');

        // $subscribCollection->getSelect()->joinLeft(array('second' => $second_table_name),
        //                                     'main_table.product_id = second.entity_id',
        //                                     array('second.value'));

        // $subscribCollection->getSelect()->joinLeft(array('third' => $third_table_name),
        //                                         'third.attribute_id = second.attribute_id',
        //                                         array('third.attribute_id as attribute_id'));

        // $subscribCollection->getSelect()->where("third.attribute_code='name' and second.entity_id=main_table.product_id");

        $subscribCollection->addFieldToFilter('main_table.subscription_id', $this->_getSubscribId());
        $singleData= $subscribCollection->getFirstItem();
        $data = $singleData->getData();
        return $data;

    }

    protected function _getSubscribId()
    {
        return $this->coreRegistry->registry(
            ViewAction::REGISTRY_KEY_POST_ID
        );
    }

    public function getSubscriptionPayments($transaction_id)
    {
        $subscriptionPaymentCollection = $this->subscriptionPaymentCollectionFactory->create();
        $subscriptionPaymentCollection->addFieldToFilter('main_table.transaction_id', $transaction_id);
        $subscriptionPaymentCollection->setOrder('main_table.created_at','DESC');

        $data = $subscriptionPaymentCollection->getData();
        return $data;
    }

    /**
     * For a given subscrib, returns its url
     * @param Subscrib $subscrib
     * @return string
     */
    public function unsubscribe($subscription_id) {
        return $this->urlInterface->getUrl('viveum/subscription/unsubscribe', ['id' => $subscription_id]);
    }

    public function detailCustomer($customer_id) {
        return $this->urlInterface->getUrl('customer/index/edit', ['id' => $customer_id]);
    }

    public function backUrl() {
        return $this->urlInterface->getUrl('viveum/subscription/index');
    }

}
