<?php
namespace Viveum\Viveum\Controller\Payment;

class Form extends \Magento\Framework\App\Action\Action
{
    protected $checkoutSession;
    private $logger;

    /**
     *
     * @param \Magento\Framework\App\Action\Context     $context
     * @param \\Magento\Checkout\Model\Session          $checkoutSession
     */
    public function __construct(
        \Magento\Framework\App\Action\Context $context,
        \Magento\Checkout\Model\Session $checkoutSession
    ) {
        parent::__construct($context);
        $this->checkoutSession = $checkoutSession;
        $this->logger = new \Viveum\Viveum\Helper\Logger("Controller\Payment\Form");
    }

    /**
     *
     * @return void
     */
    public function execute()
    {
        $paymentMethod = $this->checkoutSession->getQuote()->getPayment()->getMethod();

        $this->logger->info("execute paymentMethod", $paymentMethod);

        if ($paymentMethod == 'viveum_easycredit') {
            $this->_redirect('viveum/payment/easycredit', ['_secure' => true]);
        } else {
            $this->_redirect('viveum/payment', ['_secure' => true]);
        }
    }
}
