<?php
namespace Viveum\Viveum\Controller\Payment;

class Information extends \Viveum\Viveum\Controller\Payment
{
    /**
     * display the my payment information page
     * @return object
     */
    public function execute()
    {
    	if (!$this->customer->isLoggedIn()) {
    		$this->_redirect('customer/account/login');
    	} else {
            $resultPageFactory = $this->resultPageFactory->create();
            $resultPageFactory->getConfig()->getTitle()->set(__('FRONTEND_MC_INFO'));
    		$block = $resultPageFactory->getLayout()->getBlock('viveum_payment_information');

            $this->paymentMethod = $this->createPaymentMethodObjectByPaymentMethod('viveum_ccsaved');
            $isRecurringActive = $this->paymentMethod->getGeneralConfig('recurring');
            $block->setIsRecurringActive($isRecurringActive);

            if ($isRecurringActive) {
                $this->paymentMethod = $this->createPaymentMethodObjectByPaymentMethod('viveum_ccsaved');
                $isActive = $this->paymentMethod->getconfigData('active');
                $block->setIsCCSavedActive($isActive);
                if ($isActive) {
                    $block->setCustomerDataCC(
                        $this->information->getPaymentInformation($this->getInformationParamaters())
                    );
                }
                $this->paymentMethod = $this->createPaymentMethodObjectByPaymentMethod('viveum_ddsaved');
                $isActive = $this->paymentMethod->getconfigData('active');
                $block->setIsDDSavedActive($isActive);
                if ($isActive) {
                    $block->setCustomerDataDD(
                        $this->information->getPaymentInformation($this->getInformationParamaters())
                    );
                }
                $this->paymentMethod = $this->createPaymentMethodObjectByPaymentMethod('viveum_paypalsaved');
                $isActive = $this->paymentMethod->getconfigData('active');
                $block->setIsPaypalSavedActive($isActive);
                if ($isActive) {
                    $block->setCustomerDataPaypal(
                        $this->information->getPaymentInformation($this->getInformationParamaters())
                    );
                }

                $block->setRegisterPaymentUrl($this->_url->getUrl('viveum/payment/register', ['_secure' => true]));
                $block->setChangePaymentUrl($this->_url->getUrl('viveum/payment/change', ['_secure' => true]));
                $block->setDeletePaymentUrl($this->_url->getUrl('viveum/payment/delete', ['_secure' => true]));
            }

            return $resultPageFactory;
        }
    }
}
