<?php
namespace Viveum\Viveum\Controller\Payment;

class RecurringResponse extends \Viveum\Viveum\Controller\Payment
{
    /**
     * get payment response in the my payment information page
     * @return void
     */
    public function execute()
    {
        $checkoutId = $this->getRequest()->getParam('id');
        $informationId = $this->getRequest()->getParam('information_id');
        $paymentMethod = $this->getRequest()->getParam('payment_method');

        $this->paymentMethod = $this->createPaymentMethodObjectByPaymentMethod($paymentMethod);

        $credentials = $this->paymentMethod->getCredentials();
        $paymentStatus = $this->helperPayment->getPaymentStatus($checkoutId, $credentials);

        if (!$paymentStatus['isValid']) {
            $this->redirectErrorRecurring(null, $paymentStatus['response'], $informationId);
        } else {
            $returnCode = $paymentStatus['response']['result']['code'];
            $errorIdentifier = $this->helperPayment->getErrorIdentifier($returnCode);
            $transactionResult = $this->helperPayment->getTransactionResult($returnCode);

            if ($transactionResult == 'ACK') {
                $this->processPaymentSuccessRecurring($informationId, $paymentStatus['response']);
            } elseif ($transactionResult == 'NOK') {
                $this->redirectErrorRecurring(null, $errorIdentifier, $informationId);
            } else {
                $this->redirectErrorRecurring(null, 'ERROR_UNKNOWN', $informationId);
            }
        }
    }

    /**
     * process the payment success recurring
     * @param  string $informationId
     * @param  array $paymentStatus
     * @return void
     */
    protected function processPaymentSuccessRecurring($informationId, $paymentStatus)
    {
        $registrationParameters = $this->paymentMethod->getCredentials();
        $registrationParameters['amount'] = $this->paymentMethod->getRegisterAmount();
        $registrationParameters['currency'] = $this->getRecurringCurrency();
        $registrationParameters['transactionId'] = $paymentStatus['merchantTransactionId'];

        if( $this->paymentMethod->getCode() == "viveum_paypalsaved" ) {
            $result = $this->processPayPalSavedRecurring($informationId, $registrationParameters, $paymentStatus);
        } else {
            $result = $this->processPaymentSavedRecurring($informationId, $registrationParameters, $paymentStatus);
        }

        if ($result) {
            if ($informationId) {
                $oldRegistrationId = $paymentStatus['merchantTransactionId'];
                $this->processChangeSubscription($oldRegistrationId, $result);
                $this->helperPayment->deleteRegistration($oldRegistrationId, $registrationParameters);
                $this->redirectSuccessRecurring('SUCCESS_MC_UPDATE');
            } else {
                $this->redirectSuccessRecurring('SUCCESS_MC_ADD');
            }
        }
    }

    /**
     * process change subscription payment information
     * @param  string $oldRegistrationId
     * @param  string $result
     * @return void
     */
    protected function processChangeSubscription($oldRegistrationId, $result)
    {
        $this->logger->info("processChangeSubscription begin");
        $subscriptions = $this->subscription->getByRegistrationId($oldRegistrationId);
        $this->logger->info("processChangeSubscription subscriptions ", $subscriptions);

        if (!empty($subscriptions)) {
            foreach ($subscriptions as $key => $subscription) {
                $scheduleParameters = [];

                $charges = explode(' ', $subscription['subscription_charge']);
                $scheduleParameters['planId'] = $subscription['plan_id'];
                $scheduleParameters['paymentType'] = 'DB';
                $scheduleParameters['currency'] = $charges[0];
                $scheduleParameters['amount'] =  $charges[1];
                $scheduleParameters['registrationId'] = $result['registrationId'];
                $scheduleParameters['merchantTransactionId'] = $subscription['transaction_id'];
                $scheduleParameters['paymentMethod'] = $subscription['payment_method'];

                if (!empty($result['standingInstruction']['initialTransactionId'])) {
                    $scheduleParameters['standingInstruction']['initialTransactionId'] = $result['standingInstruction']['initialTransactionId'];
                }

                $credentials = $this->paymentMethod->getCredentials();
                $scheduleParameters = array_merge($scheduleParameters, $credentials);
                unset($scheduleParameters['testMode']);

                $this->logger->info("processChangeSubscription processDeSchedule referenceId", $subscription['subscription_id']);
                $descheduleResult = $this->helperPayment->deSchedule($subscription['subscription_id'], $credentials);
                $this->logger->info("processChangeSubscription processDeSchedule result", $descheduleResult);

                $response = $descheduleResult['response'];
                $returnCode = $response['result']['code'];
                $transactionResult = $this->helperPayment->getTransactionResult($returnCode);

                if ($transactionResult == 'ACK') {
                    $this->logger->info("processChangeSubscription processSchedule ParameterSD", $scheduleParameters);
                    $scheduleResult = $this->helperPayment->createSchedule($scheduleParameters);
                    $this->logger->info("processChangeSubscription processSchedule createSD result", $scheduleResult);

                    $response = $scheduleResult['response'];
                    $returnCode = $response['result']['code'];
                    $transactionResult = $this->helperPayment->getTransactionResult($returnCode);

                    if ($transactionResult == 'ACK') {
                        $this->subscription->updateSubscription($subscription['entity_id'], $response['id'], $response['registrationId']);
                    } else {
                        $this->logger->info("processChangeSubscription processSchedule failed");
                    }
                } else {
                    $this->logger->info("processChangeSubscription processDeSchedule failed");
                }
            }
        }
    }

    /**
     * process the PayPal recurring
     * @param  string $informationId
     * @param  array $registrationParameters
     * @param  array $paymentStatus
     * @return boolean
     */
    protected function processPayPalSavedRecurring($informationId, $registrationParameters, $paymentStatus)
    {
        $registrationId = $paymentStatus['id'];
        $registrationParameters['paymentType'] = 'DB';

        $debitStatus = $this->helperPayment->useRegisteredAccount($registrationId, $registrationParameters);

        if($debitStatus['isValid']){
            $returnCode = $debitStatus['response']['result']['code'];
            $errorIdentifier = $this->helperPayment->getErrorIdentifier($returnCode);
            $transactionResult = $this->helperPayment->getTransactionResult($returnCode);

            if ($transactionResult == 'ACK') {
                $referenceId = $debitStatus['response']['id'];
                $registrationParameters['paymentType'] = 'RF';
                $this->helperPayment->backOfficeOperation($referenceId, $registrationParameters);
                $this->savePaymentAccount($informationId, $registrationId, $paymentStatus);
                $paymentStatus['registrationId'] = $registrationId;
                return $paymentStatus;
            } else {
                $this->helperPayment->deleteRegistration($registrationId, $registrationParameters);
                if ($transactionResult == 'NOK') {
                    $this->redirectErrorRecurring(null, $errorIdentifier, $informationId);
                } else {
                    $this->redirectErrorRecurring(null, 'ERROR_UNKNOWN', $informationId);
                }
                return false;
            }
        } else {
            $this->redirectErrorRecurring(null, $debitStatus['response'], $informationId);
            return false;
        }
    }

    /**
     * process the credit cards and direct debit payment recurring
     * @param  string $informationId
     * @param  array $registrationParameters
     * @param  array $paymentStatus
     * @return boolean
     */
    protected function processPaymentSavedRecurring($informationId, $registrationParameters, $paymentStatus)
    {
        $registrationId = $paymentStatus['registrationId'];
        $referenceId = $paymentStatus['id'];
        $this->captureRecurringPayment($registrationId, $referenceId, $informationId, $registrationParameters, $paymentStatus);
        $registrationParameters['paymentType'] = 'RF';
        $this->helperPayment->backOfficeOperation($referenceId, $registrationParameters);
        $this->savePaymentAccount($informationId, $registrationId, $paymentStatus);
        return $paymentStatus;
    }

    /**
     * capture payment when order status is PA(Pre-Authorization)
     * @param  string $informationId
     * @param  array $registrationParameters
     * @param  array $paymentStatus
     * @return boolean
     */
    protected function captureRecurringPayment($registrationId, $referenceId, $informationId, $registrationParameters, $paymentStatus)
    {
        if ($paymentStatus['paymentType'] == 'PA') {
            $registrationParameters['paymentType'] = 'CP';
            $captureStatus = $this->helperPayment->backOfficeOperation($referenceId, $registrationParameters);
            if($captureStatus['isValid']){
                $returnCode = $captureStatus['response']['result']['code'];
                $errorIdentifier = $this->helperPayment->getErrorIdentifier($returnCode);
                $transactionResult = $this->helperPayment->getTransactionResult($returnCode);

                if ($transactionResult == 'ACK') {
                    $referenceId = $captureStatus['response']['id'];
                } else {
                    $this->helperPayment->deleteRegistration($registrationId, $registrationParameters);
                    if ($transactionResult == 'NOK') {
                        $this->redirectErrorRecurring(null, $errorIdentifier, $informationId);
                    } else {
                        $this->redirectErrorRecurring(null, 'ERROR_UNKNOWN', $informationId);
                    }
                }
            } else {
                $this->redirectErrorRecurring(null, $captureStatus['response'], $informationId);
            }
        }
    }
    /**
     * save a payment account
     * @param  string $informationId
     * @param  string $registrationId
     * @param  array $paymentStatus
     * @return void
     */
    protected function savePaymentAccount($informationId, $registrationId, $paymentStatus)
    {
        $registrationParameters = array_merge(
            $this->getInformationParamaters(),
            $paymentStatus,
            $this->paymentMethod->getAccount($paymentStatus)
        );
        $registrationParameters['registrationId'] = $registrationId;

        if ($informationId) {
            $this->information->updateRegistration($registrationParameters, $informationId);
        } else {
            $this->information->insertRegistration($registrationParameters);
        }
    }

}
