<?php

namespace Viveum\Viveum\Helper;

use Magento\Checkout\Model\Cart;
use Magento\Framework\App\Helper\AbstractHelper;
use Psr\Log\LoggerInterface;
use Magento\Catalog\Model\Product;

class Subscription extends AbstractHelper
{
    /**
     * @var Product
     */
    private $product;
    /**
     * @var \Magento\Framework\App\ObjectManager
     */
    private $objectManagement;
    /**
     * @var LoggerInterface
     */
    protected $logger;
    /**
     * @var Cart
     */
    private $cart;

    public function __construct(Product $product, LoggerInterface $logger, Cart  $cart)
    {
        $this->product = $product;
        $this->logger = $logger;
        $this->cart = $cart;
        $this->objectManagement = \Magento\Framework\App\ObjectManager::getInstance();
    }

    /**
     * @param $cartItems
     * @param $validateTo
     * @return bool
     */
    public function validateIsASubscriptionProduct($cartItems, $validateTo)
    {
        try{
            foreach($cartItems as $item){
                $option = $item->getOptionByCode('additional_options');
                $data = $option ? json_decode($option->getValue(), true) : [];

                $this->logger->info('DATA:'.json_encode($data));

                if (array_key_exists("paymentOption", $data) && in_array($validateTo, $data)) {
                    return true;
                }
            }
        } catch (\Exception $e) {
            $this->logger->critical("Exception: {$e->getMessage()}");
            return false;
        }
    }

    public function validateRegularProduct($cartItems)
    {
        try{
            foreach($cartItems as $item){
                $subscription_plan = $item->getOptionByCode('subscription_plan');
                if(!empty($subscription_plan)) return false;
            }
            return true;
        } catch (\Exception $e) {
            $this->logger->critical("Exception: {$e->getMessage()}");
            return false;
        }
    }

    public function validateSubscription($cartItems)
    {
        try{
            foreach($cartItems as $item){
                $subscription_plan = $item->getOptionByCode('subscription_plan');
                if(empty($subscription_plan)) return false;
            }
            return true;
        } catch (\Exception $e) {
            $this->logger->critical("Exception: {$e->getMessage()}");
            return false;
        }
    }

}
