<?php
namespace Viveum\Viveum\Model\Source;

class PlanStatus implements \Magento\Framework\Data\OptionSourceInterface
{
    /**
     * @var \Viveum\Viveum\Model\Subscription\Plan
     */
    protected $_plan;


    public function __construct(\Viveum\Viveum\Model\Subscription\Plan $plan)
    {
        $this->_plan = $plan;
    }

    /**
     * Get options
     *
     * @return array
     */
    public function toOptionArray()
    {
        $options[] = ['label' => '', 'value' => ''];
        $availableOptions = $this->_plan->getAvailableStatuses();
        foreach ($availableOptions as $key => $value) {
            $options[] = [
                'label' => $value,
                'value' => $key,
            ];
        }
        return $options;
    }
}
