<?php
namespace Viveum\Viveum\Model\Subscription;

class Subscription extends \Magento\Framework\Model\AbstractModel
{
    /**
     * Define resource model
     */
    protected function _construct()
    {
        $this->_init('Viveum\Viveum\Model\ResourceModel\Subscription\Subscription');
    }

    public function getAllSubscriptions()
    {
        $collection = $this->getCollection();
        return $collection->getData();
    }

    public function getByRegistrationId($registrationId)
    {
        $collection = $this->getCollection();
        $collection->addFieldToFilter('registration_id', $registrationId);
        $collection->addFieldToFilter('status', 'active');

        return $collection->getData();
    }

    public function getBySubscriptionId($subscriptionId)
    {
        $collection = $this->getCollection()
            ->addFieldToFilter('subscription_id', $subscriptionId);

        return $collection->getData();
    }

    public function getByTransactionId($transactionId)
    {
        $collection = $this->getCollection()
            ->addFieldToFilter('transaction_id', $transactionId);

        return $collection->getData();
    }

    public function insertSubscription($parameters)
    {
        try{

            $this->setData ('subscription_id', $parameters['id']);
            $this->setData ('registration_id', $parameters['registration_id']);
            $this->setData ('plan_id', $parameters['plan_id']);
            $this->setData ('transaction_id', $parameters['transaction_id']);
            $this->setData ('quote_id', $parameters['quote_id']);

            if (empty($parameters['magento_user_id']) || $parameters['magento_user_id'] == 'NULL') {
                $parameters['magento_user_id'] = NULL;
            }

            $this->setData ('magento_user_id', $parameters['magento_user_id']);
            $this->setData ('customer_firstname', $parameters['customer_firstname']);
            $this->setData ('customer_lastname', $parameters['customer_lastname']);
            $this->setData ('customer_email', $parameters['customer_email']);

            $this->setData ('subscription_charge', $parameters['amount']);
            $this->setData ('payment_method', $parameters['payment_method']);
            $this->setData ('status', 'active');
            $this->setData ('start_at', date("Y-m-d h:i:sa"));
            $this->save();

            return true;
        }catch(\Exception $e)
        {
            return false;
        }
    }

    public function updateSubscription($id, $subscriptionId, $registrationId)
    {
        try {
            $this->load($id);
            $this->setData ('subscription_id', $subscriptionId);
            $this->setData ('registration_id', $registrationId);
            $this->save();

            return true;
        }
        catch (\Exception $e) {
            return false;
        }
    }

}
