<?php

namespace Viveum\Viveum\Observer;

use Magento\Framework\Event\ObserverInterface;

class AdminOrderPlaceAfter implements ObserverInterface
{
	protected $payment;
	protected $sessionQuote;

    /**
     *
     * @param \Viveum\Viveum\Controller\Payment $payment
     * @param \Magento\Backend\Model\Session\Quote              $sessionQuote
     */
    public function __construct(
        \Viveum\Viveum\Controller\Payment $payment,
        \Magento\Backend\Model\Session\Quote $sessionQuote
    ) {
        $this->payment = $payment;
        $this->sessionQuote = $sessionQuote;
        $this->statusPA = \Viveum\Viveum\Model\Method\AbstractMethod::STATUS_PA;
    }

    /**
     *
     * @param  \Magento\Framework\Event\Observer $observer
     * @return void
     */
	public function execute(\Magento\Framework\Event\Observer $observer)
    {
		$orderEvent = $observer->getEvent()->getOrder();
		$paymentOrder = $orderEvent->getPayment();
		$paymentMethod = $paymentOrder->getMethod();

        $isViveumMethod = $this->payment->isViveumMethod($paymentMethod);
        if ($isViveumMethod) {
            $this->payment->paymentMethod = $this->payment->createPaymentMethodObjectByPaymentMethod($paymentMethod);

            if ($this->payment->paymentMethod->isAdminLoggedIn()) {
                $this->payment->order = $orderEvent;

                $registrationId = $this->sessionQuote->getViveumRegistrationId();
                $this->sessionQuote->unsViveumRegistrationId();
                $this->sessionQuote->unsViveumPaymentMethod();

            	$paymentParameters = array_merge_recursive(
    	            $this->payment->paymentMethod->getCredentials(),
        	        $this->payment->getTransactionParameters(),
                    $this->payment->getCustomParameters()
        	    );

    			$paymentStatus = $this->payment->helperPayment->useRegisteredAccount($registrationId, $paymentParameters);

                if($paymentStatus['isValid']){
        	        $returnCode = $paymentStatus['response']['result']['code'];
        	        $returnMessage = __($this->payment->helperPayment->getErrorIdentifier($returnCode));
        	        $transactionResult = $this->payment->helperPayment->getTransactionResult($returnCode);

        			$this->payment->saveOrderAdditionalInformation($paymentStatus['response'], $orderEvent);

        			if ($transactionResult == 'ACK') {
        		        if ($paymentStatus['response']['paymentType'] == 'PA') {
        		            $orderEvent->setState('new')->setStatus($this->statusPA)->save();
        		            $orderEvent->addStatusToHistory($this->statusPA, '', true)->save();
        		        } else {
        		            $this->payment->createInvoice();
        		        }
        		    } elseif ($transactionResult == 'NOK') {
                        throw new \Magento\Framework\Exception\LocalizedException(__($returnMessage));
                    } else {
                        throw new \Magento\Framework\Exception\LocalizedException(__('ERROR_UNKNOWN'));
                    }
                } else{
                    throw new \Magento\Framework\Exception\LocalizedException(__($paymentStatus['response']));
                }
            }
        }
    }
}
