<?php

namespace Viveum\Viveum\Observer;

use Magento\Framework\Event\ObserverInterface;

class AdminOrderPlaceBefore implements ObserverInterface
{
	protected $payment;

    /**
     *
     * @param \Viveum\Viveum\Controller\Payment $payment
     */
    public function __construct(
        \Viveum\Viveum\Controller\Payment $payment
    ) {
        $this->payment = $payment;
    }

    /**
     *
     * @param  \Magento\Framework\Event\Observer $observer
     * @return void
     */
	public function execute(\Magento\Framework\Event\Observer $observer)
    {
		$order = $observer->getEvent()->getOrder();
		$payment = $order->getPayment();
		$paymentMethod = $payment->getMethod();

        $isViveumMethod = $this->payment->isViveumMethod($paymentMethod);
        if ($isViveumMethod) {
            $this->payment->paymentMethod = $this->payment->createPaymentMethodObjectByPaymentMethod($paymentMethod);
            $this->payment->_order = $order;
        }
    }
}
