<?php

namespace Viveum\Viveum\Observer;

use Magento\Framework\Event\Observer as EventObserver;
use Magento\Framework\Event\ObserverInterface;
use Magento\Framework\Message\Error;

class CheckoutCartProductAddAfterObserver implements ObserverInterface
{
    /**
     * @var \Magento\Framework\App\Request\Http
     */
    protected $request;

    /**
     * @var \Psr\Log\LoggerInterface
     */
    private $logger;

    /**
     * @var \Magento\Framework\Serialize\SerializerInterface
     */
    private $serializer;

    private $objectManagement;

    /**
     * @param \Magento\Store\Model\StoreManagerInterface $storeManager
     * @param \Magento\Framework\App\RequestInterface $request
     * @param \Magento\Framework\Serialize\SerializerInterface $serializer
     * @param \Psr\Log\LoggerInterface $logger
     */
    public function __construct(
        \Magento\Framework\App\RequestInterface $request,
        \Magento\Framework\Serialize\SerializerInterface $serializer,
        \Psr\Log\LoggerInterface $logger
    )
    {
        $this->request = $request;
        $this->serializer = $serializer;
        $this->logger = $logger;
        $this->objectManagement = \Magento\Framework\App\ObjectManager::getInstance();
    }

    /**
     * @param EventObserver $observer
     * @return void
     */
    public function execute(EventObserver $observer)
    {
        $paymentOption = $this->request->getParam('paymentOption');
        $planId = $this->request->getParam('plan_id');

        /* @var \Magento\Quote\Model\Quote\Item $item */
        $items = $observer->getEvent()->getQuoteItem();

        if ($paymentOption == 'subscription') {
            foreach ($items->getQuote()->getAllItems() as $item) {
                $additionalOptions = array();

                $additionalOptions[] = [
                    'label' => "Subscription Plan",
                    'value' => ucfirst($planId)
                ];

                $item->addOption(array(
                    'product_id' => $item->getProductId(),
                    'code' => 'additional_options',
                    'value' => $this->serializer->serialize($additionalOptions)
                ));

                $item->addOption(array(
                    'product_id' => $item->getProductId(),
                    'code' => 'subscription_plan',
                    'value' => $planId
                ));
            }
        }

    }
}
