<?php
namespace Viveum\Viveum\Observer;

use Magento\Framework\Event\ObserverInterface;

class InvoiceRegisterObserver implements ObserverInterface
{
    /**
     *
     * @param  \Magento\Framework\Event\Observer $observer
     * @return void
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $order = $observer->getEvent()->getOrder();
        $paymentMethod = $order->getPayment()->getMethod();
        $statusDB = \Magento\Sales\Model\Order::STATE_PROCESSING;
        if (strpos($paymentMethod, 'viveum') !== false) {
            $order->setStatus($statusDB);
            $order->addStatusToHistory($statusDB, '', true)->save();
        }
    }
}
