<?php
namespace Viveum\Viveum\Observer;

use Magento\Framework\Event\ObserverInterface;
use Magento\Catalog\Api\ProductRepositoryInterface;

class PaymentMethodAvailableObserver implements ObserverInterface
{
    protected $_cart;
    protected $_checkoutSession;
    protected $productRepository;
    public function __construct(
        \Magento\Checkout\Model\Cart $cart,
        \Magento\Checkout\Model\Session $checkoutSession,
        ProductRepositoryInterface $productRepository
    )
    {
        $this->_cart = $cart;
        $this->_checkoutSession = $checkoutSession;
        $this->productRepository = $productRepository;
    }
    /**
     * Execute observer
     *
     * @param \Magento\Framework\Event\Observer $observer
     * @return void
     */
    public function execute(\Magento\Framework\Event\Observer $observer)
    {
        $quote = $this->getCheckoutSession()->getQuote();
        $items = $quote->getAllItems();
        $isSubscriptionProduct = false;

        foreach ($items as $item) {
            $subscription_plan = $item->getOptionByCode('subscription_plan');
            if (!empty($subscription_plan)){
                $isSubscriptionProduct = true;
                break;
            }
        }

        if ($isSubscriptionProduct == true){

            $checkResult = $observer->getEvent()->getResult();

            if ($observer->getEvent()->getMethodInstance()->getCode()=="viveum_ccsaved" ||
                $observer->getEvent()->getMethodInstance()->getCode()=="viveum_creditcard" ||
                $observer->getEvent()->getMethodInstance()->getCode()=="viveum_paypal" ||
                $observer->getEvent()->getMethodInstance()->getCode()=="viveum_paypalsaved"
            ) {
                $checkResult->setData('is_available', true);
            } else {
                $checkResult->setData('is_available', false);
            }

        }

    }

    public function getProduct($productId)
    {
        return $product = $this->productRepository->getById($productId);
    }

    public function getCart()
    {
        return $this->_cart;
    }

    public function getCheckoutSession()
    {
        return $this->_checkoutSession;
    }
}
