/**
 * Copyright © 2015 Magento. All rights reserved.
 * See COPYING.txt for license details.
 */
/*browser:true*/
/*global define*/
define(
    [
        'jquery',
        'Magento_Checkout/js/view/payment/default',
        'Viveum_Viveum/js/action/set-payment-method',
        'Magento_Checkout/js/model/quote',
        'Magento_Checkout/js/model/payment/additional-validators',
        'Magento_CheckoutAgreements/js/model/agreements-assigner'
    ],
    function ($, Component, setPaymentMethodAction, quote, additionalValidators, agreementsAssigner) {
        'use strict';

        var isEasyCreditErrorAmount = function () {
            var quoteCurrencyCode = quote.totals()['base_currency_code'];
            var quoteGrandTotal = quote.totals()['base_grand_total'];
            if (quoteGrandTotal < 200 || quoteGrandTotal > 5000 || quoteCurrencyCode != "EUR") {
                return true;
            }
            return false;
        };

        var customerAddress = function () {
            var streets = quote.billingAddress()['street'];
            var complete_street = "";
            if (typeof streets !== 'undefined' && streets.length > 0) {
                streets.forEach(function(street){
                    
                    complete_street = complete_street + street + " ";
                });
                complete_street = complete_street + ", " + quote.billingAddress()['postcode'] + ", " + quote.billingAddress()['city'];
            }
            return complete_street;
        }

        var isSubscriptionItem = function () {
            var items = quote.getItems();

            for (var i = 0; i < items.length; i++) {
                if (items[i].options.length && items[i].options[0].label == 'Subscription Plan') {
                    return true;
                }
            }

            return false;
        }

        return Component.extend({
            defaults: {
                template: 'Viveum_Viveum/payment/viveum-method',
                userConsent: ''
            },
            initObservable: function () {
                this._super()
                    .observe('userConsent');
                return this;
            },
            getData: function () {
                return {
                    method: this.item.method,
                    'additional_data': {
                        'viveum_user_consent': ($('#viveum_user_consent') && $('#viveum_user_consent').prop('checked')) ? 1 : 0
                    }
                };
            },
            /** Redirect to Payment Form */
            placeOrderAction: function () {
                var validate = true;
                if ( additionalValidators.validate() ) {
                    if (this.getCode() == 'viveum_klarnapaylater' || this.getCode() == 'viveum_klarnasliceit') {
                        if ($('#'+'billing-address-same-as-shipping-'+this.getCode()).attr('checked') != 'checked') {
                            $('#'+this.getCode()+'_address_error').show();
                            validate = false;
                        } else {
                            $('#'+this.getCode()+'_address_error').hide();
                        }
                        if ($('#'+this.getCode()+'_term').attr('checked') != 'checked') {
                            $('#'+this.getCode()+'_term_error').show();
                            validate = false;
                        } else {
                            $('#'+this.getCode()+'_term_error').hide();
                        }
                    }
                    if(this.getCode() == 'viveum_easycredit'){
                        var billingAddressSameAsShipping = document.querySelectorAll('[name=billing-address-same-as-shipping]');
                        
                        if ($('#'+this.getCode()+'_term').attr('checked') != 'checked') {
                            $('#'+this.getCode()+'_term_error').show();
                            validate = false;
                        } else {
                            $('#'+this.getCode()+'_term_error').hide();
                        }
                        if (billingAddressSameAsShipping.length > 1) {
                            if ($('#'+'billing-address-same-as-shipping-'+this.getCode()).attr('checked') != 'checked') {
                                $('#'+this.getCode()+'_address_error').show();
                                validate = false;
                            } else {
                                $('#'+this.getCode()+'_address_error').hide();
                            }
                        } else {
                            if ($('[name=billing-address-same-as-shipping]').attr('checked') != 'checked') {
                                $('#'+this.getCode()+'_address_error').show();
                                validate = false;
                            } else {
                                $('#'+this.getCode()+'_address_error').hide();
                            }
                        }
                    }
                    if(this.getCode() == 'viveum_paypalsaved'){
                        var isSubscription = isSubscriptionItem();
                        var checked = $('#viveum_user_consent').prop('checked');

                        if (!checked && isSubscription) {
                            validate = false;
                            $('#viveum_user_consent_error').show();
                        } else {
                            $('#viveum_user_consent_error').hide();
                        }
                    }

                    if (!validate) {
                        return false;
                    }
                    this.selectPaymentMethod(); // save selected payment method in Quote
                    var paymentData = {
                        method: this.getCode()
                    };
                    agreementsAssigner(paymentData);
                    setPaymentMethodAction(
                        this.messageContainer,
                        this.getData()
                    );
                    return false;
                }
            },
            getLogos: function () {
                return window.checkoutConfig.payment.viveum.logos[this.getCode()];
            },
            getDetails: function () {
                return window.checkoutConfig.payment.viveum.details[this.getCode()];
            },
            isSubscription: function () {
                return isSubscriptionItem();
            },
            getEasyCreditErrorAmount: function () {
                return window.checkoutConfig.payment.viveum.details[this.getCode()]['errorAmount'];
            },            
            renderKlarnaPaylaterTerms: function() {
                new Klarna.Terms.Invoice({
                    el: "klarna_invoice_terms",
                    eid: window.checkoutConfig.payment.viveum.details['viveum_klarnapaylater'].merchantId,
                    locale: "de_de",
                    charge: 0,
                    type: 'desktop'
                });
            },
            renderKlarnaSliceitTerms: function() {
                new Klarna.Terms.Account({
                    el: "klarna_account_terms",
                    eid: window.checkoutConfig.payment.viveum.details['viveum_klarnasliceit'].merchantId,
                    locale: "de_de",
                    type: 'desktop'
                });
            },
            renderKlarnaPaylaterConsent: function() {
                new Klarna.Terms.Consent({  
                    el: 'klarna_invoice_consent',
                    eid: window.checkoutConfig.payment.viveum.details['viveum_klarnapaylater'].merchantId,
                    locale: 'de_de',
                    type: 'desktop'
                });
            },
            renderKlarnaSliceItConsent: function() {
                new Klarna.Terms.Consent({  
                    el: 'klarna_account_consent',
                    eid: window.checkoutConfig.payment.viveum.details['viveum_klarnasliceit'].merchantId,
                    locale: 'de_de',
                    type: 'desktop'
                });
            },
            isDisabled: function() {
                var isAvailable = true;
                if(this.getCode() == 'viveum_easycredit'){

                    var easycreditTermTextTemplate = window.checkoutConfig.payment.viveum.details['viveum_easycredit'].easycreditTerms;
                    var billingAddressFromCart = customerAddress();
                    var easycreditTermText = easycreditTermTextTemplate.replace("%y", billingAddressFromCart);
                    $('#viveum_easycredit_term_error_text').text(easycreditTermText);
                    $('#gender').on('change', function() {
                        
                        if(this.value !=="" && !$("#viveum_easycredit_errorAmount").is(":visible")){
                            $('#viveum_easycredit').removeAttr("disabled");
                            $.cookie("gender", this.value);
                        } else {
                            $('#viveum_easycredit').prop('disabled', true);
                            $('#viveum_easycredit').prop('checked', false);
                        }

                    });
                    var billingAddressSameAsShipping = document.querySelectorAll('[name=billing-address-same-as-shipping]');
                    [].forEach.call(billingAddressSameAsShipping, function(elm){
                        $(elm).on('click', function() {
                            if ($(this).is(':checked')) {
                                $('#viveum_easycredit_address_error').hide();        
                            }
                        });
                    });
                    var errorAmount = isEasyCreditErrorAmount();
                    var errorGender = window.checkoutConfig.payment.viveum.details['viveum_easycredit'].errorGender;
                    
                    if(errorAmount){
                        $('#viveum_easycredit').prop('disabled', true);
                        $('#viveum_easycredit').prop('checked', false);
                        $("#viveum_easycredit_errorAmount").show();
                        $('#viveum_easycredit_payment_content').hide();
                        isAvailable = false;
                    }else{
                        if (quote.paymentMethod()) {
                            if (quote.paymentMethod()['method'] == 'viveum_easycredit'){
                                $('#viveum_easycredit_payment_content').show();
                            } else {
                                $('#viveum_easycredit_payment_content').hide();
                            }
                        }
                        $("#viveum_easycredit_errorAmount").hide();
                    }

                    if(errorGender != ''){
                        $("#viveum_easycredit_errorGender").show();
                        isAvailable = false;
                    }else{
                        $("#viveum_easycredit_errorGender").hide();
                        $("#field_gender").hide();
                    }
                }

                return isAvailable;
            },
            easyCreditTermInit: function() {
                var paymentRadio = document.querySelectorAll('.payment-group .payment-method input[type=radio]');
                [].forEach.call(paymentRadio, function(elm) {
                    if ($(elm).closest('.payment-method').hasClass('_active')) {
                        if ($(elm).val() == 'viveum_easycredit') {
                            $('#easycreditTerms').show();
                        }
                    }
                    $(elm).click(function() {
                        if (this.value == 'viveum_easycredit') {
                            $('#easycreditTerms').show();
                        } else {
                            $('#easycreditTerms').hide();
                        }
                    });
                });
            }
        });
    }
);
