<?php
/**
 * Viveum Apple Pay
 *
 * The gateway is used for Apple Pay.
 * Copyright (c) Viveum
 *
 * @class      Gateway_Viveum_Applepay
 * @package    Viveum/Gateway
 * @extends    Viveum_Payment_Gateway
 * @located at /includes/gateways
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * The gateway is used for Apple Pay.
 */
class Gateway_Viveum_Applepay extends Viveum_Payment_Gateway {
	/**
	 * Identifier Apple Pay
	 *
	 * @var string $id
	 */
	public $id = 'viveum_applepay';

	/**
	 * Payment brand
	 *
	 * @var string $payment_brand
	 */
	protected $payment_brand = 'APPLEPAY';

	/**
	 * Card types
	 *
	 * @var string $card_types
	 */
	protected $card_types = 'amex chinaUnionPay discover jcb masterCard visa';

    /**
	 * Get Payment Logo( s ) to get_icon()
	 *
	 * @return string
	 */
	public function viveum_get_payment_logo() {
		return $this->plugins_url . '/assets/images/applepay ' . $this->settings['button_style'] . '.svg';
	}

	/**
	 * Get payment method backend configuration form fields
	 */
	public function get_backend_configuration_form_fields() {
		$form_fields = parent::get_backend_configuration_form_fields();
		$form_fields['applepay_merchant_id'] = array(
            'title'   => __( 'Apple Pay Merchant Identifier', 'wc-viveum' ) . ' * ',
            'type'    => 'text',
			'custom_attributes' => array( 'required' => 'required' ),
        );
		$form_fields['button_style'] = array(
            'title'   => __( 'Button Style', 'wc-viveum' ),
			'css'   => 'padding: 1px;',
			'type' => 'select',
			'options' => array(
				'white-with-line' => __( 'White with Line', 'wc-viveum' ),
				'white' => __( 'white', 'wc-viveum' ),
				'black' => __( 'black', 'wc-viveum' ),
			),
			'default' => 'white-with-line',
        );
        $form_fields['shop_name'] = array(
			'title' => __( 'Shop Name', 'wc-viveum' ) . ' * ',
			'type' => 'text',
			'custom_attributes' => array( 'required' => 'required' ),
		);
		$form_fields['card_types'] = array(
			'title' => __( 'Card Types', 'wc-viveum' ) . ' * ',
			'type' => 'multiselect',
			'options' => array(
				'visa' => __( 'VISA', 'wc-viveum' ),
				'masterCard' => __( 'MasterCard', 'wc-viveum' ),
				'discover' => __( 'Discover', 'wc-viveum' ),
				'jcb' => __( 'JCB', 'wc-viveum' ),
				'amex' => __( 'American Express', 'wc-viveum' ),
				'chinaUnionPay' => __( 'China Union Pay', 'wc-viveum' ),
			),
			'custom_attributes' => array( 'required' => 'required' ),
		);
		$form_fields['trans_mode'] = array(
			'title' => __( 'Transaction-Mode', 'wc-viveum' ),
			'css'   => 'padding: 1px;',
			'type' => 'select',
			'options' => array(
				'PA' => __( 'Pre-Authorization', 'wc-viveum' ),
				'DB' => __( 'Debit', 'wc-viveum' ),
			),
			'default' => 'PA',
		);

		return $form_fields;
	}

	/**
	 * Get payment method title.
	 *
	 * @return string
	 */
	public function get_title() {
		return __( 'Apple Pay', 'wc-viveum' );
	}
}

$obj = new Gateway_Viveum_Applepay();
