<?php
/**
 * Viveum Credit Card
 *
 * The gateway is used for Credit card.
 * Copyright (c) Viveum
 *
 * @class      Gateway_Viveum_CC
 * @package    Viveum/Gateway
 * @extends    Viveum_Payment_Gateway
 * @located at /includes/gateways
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * The gateway is used for Credit card.
 */
class Gateway_Viveum_CC extends Viveum_Payment_Gateway {
	/**
	 * Identifier CC
	 *
	 * @var string $id
	 */
	public $id = 'viveum_cc';

	/**
	 * Payment brand
	 *
	 * @var string $payment_brand
	 */
	protected $payment_brand = 'VISA MASTER AMEX DINERS JCB';

	/**
	 * From class WC_Payment_Gateway
	 * Payment gateway icon.
	 */
	public function get_icon() {
		$icon_html = $this->viveum_get_multi_icon();
		return apply_filters( 'woocommerce_gateway_icon', $icon_html, $this->id );
	}

	/**
	 * Get payment method backend configuration form fields
	 */
	public function get_backend_configuration_form_fields() {
		$form_fields = parent::get_backend_configuration_form_fields();
		$form_fields['card_types'] = array(
			'title' => __( 'Card Types', 'wc-viveum' ),
			'type' => 'multiselect',
			'options' => array(
				'VISA' => __( 'VISA', 'wc-viveum' ),
				'MASTER' => __( 'MasterCard', 'wc-viveum' ),
				'AMEX' => __( 'American Express', 'wc-viveum' ),
				'DINERS' => __( 'Diners', 'wc-viveum' ),
				'JCB' => __( 'JCB', 'wc-viveum' ),
			),
		);
		$form_fields['trans_mode'] = array(
			'title' => __( 'Transaction-Mode', 'wc-viveum' ),
			'css'   => 'padding: 1px;',
			'type' => 'select',
			'options' => array(
				'PA' => __( 'Pre-Authorization', 'wc-viveum' ),
				'DB' => __( 'Debit', 'wc-viveum' ),
			),
			'default' => 'PA',
		);

		return $form_fields;
	}

	/**
	 * Get payment method title.
	 *
	 * @return string
	 */
	public function get_title() {
		if ( is_admin() ) {
			return __( 'Credit Cards', 'wc-viveum' );
		}

		return __( 'Credit Cards', 'wc-viveum' );
	}
}

$obj = new Gateway_Viveum_CC();
