<?php
/**
 * Viveum Direct Debit Recurring
 *
 * The gateway is used for Direct Debit Recurring.
 * Copyright (c) Viveum
 *
 * @class       Gateway_Viveum_DDSaved
 * @package     Viveum/Gateway
 * @extends     Viveum_Payment_Gateway
 * @located at  /includes/gateways
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * The gateway is used for Direct Debit Recurring.
 */
class Gateway_Viveum_DDSaved extends Gateway_Viveum_DD {
	/**
	 * Identifier DD
	 *
	 * @var string $id
	 */
	public $id = 'viveum_ddsaved';

	/**
	 * Payment group
	 *
	 * @var string $payment_group
	 */
	protected $payment_group = 'DD';

	/**
	 * Is recurring
	 *
	 * @var bool $is_recurring
	 */
	protected $is_recurring = true;

	/**
	 * Get payment method backend configuration form fields
	 */
	public function get_backend_configuration_form_fields() {
		$form_fields = parent::get_backend_configuration_form_fields();
		$form_fields['amount_registration'] = array(
			'title' => __( 'Amount for Registration', 'wc-viveum' ),
			'type' => 'text',
			'default' => '',
			'description' => __( 'Amount that is debited and refunded when a shopper registers a payment method without purchase', 'wc-viveum' ),
		);

		return $form_fields;
	}

	/**
	 * Get payment method title.
	 *
	 * @return string
	 */
	public function get_title() {
		if ( is_admin() ) {
			return __( 'Direct Debit (Recurring)', 'wc-viveum' );
		}

		return __( 'Direct Debit', 'wc-viveum' );
	}
}

$obj = new Gateway_Viveum_DDSaved();
