<?php
/**
 * Viveum easyCredit
 *
 * The gateway is used for easyCredit.
 * Copyright (c) Viveum
 *
 * @class      Gateway_Viveum_Easycredit
 * @package    Viveum/Gateway
 * @extends    Viveum_Payment_Gateway
 * @located at /includes/gateways
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * The gateway is used for easyCredit.
 */
class Gateway_Viveum_Easycredit extends Viveum_Payment_Gateway {
	/**
	 * Identifier easycredit
	 *
	 * @var string $id
	 */
	public $id = 'viveum_easycredit';

	/**
	 * Payment type
	 *
	 * @var string $payment_type
	 */
	protected $payment_type = 'PA';

	/**
	 * Payment brand
	 *
	 * @var string $payment_brand
	 */
	protected $payment_brand = 'RATENKAUF';

	/**
	 * Get payment method backend configuration form fields
	 */
	public function get_backend_configuration_form_fields() {
		$form_fields = parent::get_backend_configuration_form_fields();
		$form_fields['shop_name'] = array(
			'title' => __( 'Shop Name', 'wc-viveum' ) . ' * ',
			'type' => 'text',
			'custom_attributes' => array( 'required' => 'required' )
		);

		return $form_fields;
	}

	/**
	 * Get Payment Logo( s ) to get_icon()
	 *
	 * @return string
	 */
	public function viveum_get_payment_logo() {
		$logo = $this->plugins_url . '/assets/images/easycredit.png';

		return $logo;
	}

	/**
	 * Get payment method title.
	 *
	 * @return string
	 */
	public function get_title() {
		if ( is_admin() ) {
			return __( 'ratenkauf by easyCredit', 'wc-viveum' );
		}

		return __( 'ratenkauf by easyCredit', 'wc-viveum' );
	}
}

$obj = new Gateway_Viveum_Easycredit();
