<?php
/**
 * Viveum Giropay
 *
 * The gateway is used for Giropay.
 * Copyright (c) Viveum
 *
 * @class      Gateway_Viveum_Giropay
 * @package    Viveum/Gateway
 * @extends    Viveum_Payment_Gateway
 * @located at /includes/gateways
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * The gateway is used for Giropay.
 */
class Gateway_Viveum_Giropay extends Viveum_Payment_Gateway {
	/**
	 * Identifier giropay
	 *
	 * @var string $id
	 */
	public $id = 'viveum_giropay';

	/**
	 * Payment brand
	 *
	 * @var string $payment_brand
	 */
	protected $payment_brand = 'GIROPAY';

	/**
	 * When doing payment in TEST system. use this value as testMode parameter.
	 *
	 * @var string $test_mode
	 */
	public $test_mode = 'INTERNAL';

	/**
	 * Get Payment Logo( s ) to get_icon()
	 *
	 * @return string
	 */
	public function viveum_get_payment_logo() {
		return $this->plugins_url . '/assets/images/giropay.png';
	}

	/**
	 * Get payment method title.
	 *
	 * @return string
	 */
	public function get_title() {
		if ( is_admin() ) {
			return __( 'giropay', 'wc-viveum' );
		}

		return __( 'giropay', 'wc-viveum' );
	}
}

$obj = new Gateway_Viveum_Giropay();
