<?php
/**
 * Viveum Google Pay
 *
 * The gateway is used for Google Pay.
 * Copyright (c) Viveum
 *
 * @class      Gateway_Viveum_Googlepay
 * @package    Viveum/Gateway
 * @extends    Viveum_Payment_Gateway
 * @located at /includes/gateways
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * The gateway is used for Google Pay.
 */
class Gateway_Viveum_Googlepay extends Viveum_Payment_Gateway {
	/**
	 * Identifier Google Pay
	 *
	 * @var string $id
	 */
	public $id = 'viveum_googlepay';

	/**
	 * Payment brand
	 *
	 * @var string $payment_brand
	 */
	protected $payment_brand = 'GOOGLEPAY';

	/**
	 * Card types
	 *
	 * @var string $card_types
	 */
	protected $card_types = 'VISA MASTERCARD DISCOVER JCB AMEX';

    /**
	 * Get Payment Logo( s ) to get_icon()
	 *
	 * @return string
	 */
	public function viveum_get_payment_logo() {
		return $this->plugins_url . '/assets/images/googlepay.png';
	}

	/**
	 * Get payment method backend configuration form fields
	 */
	public function get_backend_configuration_form_fields() {
		$form_fields = parent::get_backend_configuration_form_fields();
		$form_fields['google_merchant_id'] = array(
            'title'   => __( 'Google Merchant ID', 'wc-viveum' ) . ' * ',
            'type'    => 'text',
			'custom_attributes' => array( 'required' => 'required' ),
        );
        $form_fields['shop_name'] = array(
			'title' => __( 'Shop Name', 'wc-viveum' ) . ' * ',
			'type' => 'text',
			'custom_attributes' => array( 'required' => 'required' ),
		);
		$form_fields['auth_methods'] = array(
			'title' => __( 'Auth Methods', 'wc-viveum' ) . ' * ',
			'type' => 'multiselect',
			'options' => array(
				'PAN_ONLY' => __( 'PAN Only', 'wc-viveum' ),
				'CRYPTOGRAM_3DS' => __( 'Cryptogram 3DS', 'wc-viveum' ),
			),
			'custom_attributes' => array( 'required' => 'required' ),
		);
		$form_fields['card_types'] = array(
			'title' => __( 'Card Types', 'wc-viveum' ) . ' * ',
			'type' => 'multiselect',
			'options' => array(
				'VISA' => __( 'VISA', 'wc-viveum' ),
				'MASTERCARD' => __( 'MasterCard', 'wc-viveum' ),
				'DISCOVER' => __( 'Discover', 'wc-viveum' ),
				'JCB' => __( 'JCB', 'wc-viveum' ),
				'AMEX' => __( 'American Express', 'wc-viveum' ),
			),
			'custom_attributes' => array( 'required' => 'required' ),
		);
		$form_fields['trans_mode'] = array(
			'title' => __( 'Transaction-Mode', 'wc-viveum' ),
			'css'   => 'padding: 1px;',
			'type' => 'select',
			'options' => array(
				'PA' => __( 'Pre-Authorization', 'wc-viveum' ),
				'DB' => __( 'Debit', 'wc-viveum' ),
			),
			'default' => 'PA',
		);

		return $form_fields;
	}

	/**
	 * Get payment method title.
	 *
	 * @return string
	 */
	public function get_title() {
		return __( 'Google Pay', 'wc-viveum' );
	}
}

$obj = new Gateway_Viveum_Googlepay();
