<?php
/**
 * Viveum Ideal
 *
 * The gateway is used for Ideal.
 * Copyright (c) Viveum
 *
 * @class      Gateway_Viveum_Ideal
 * @package    Viveum/Gateway
 * @extends    Viveum_Payment_Gateway
 * @located at /includes/gateways
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * The gateway is used for Ideal.
 */
class Gateway_Viveum_Ideal extends Viveum_Payment_Gateway {
	/**
	 * Identifier ideal
	 *
	 * @var string $id
	 */
	public $id = 'viveum_ideal';

	/**
	 * Get Payment Logo( s ) to get_icon()
	 *
	 * @return string
	 */
	public function viveum_get_payment_logo() {
		return $this->plugins_url . '/assets/images/ideal.png';
	}

	/**
	 * Get payment method title.
	 *
	 * @return string
	 */
	public function get_title() {
		if ( is_admin() ) {
			return __( 'iDeal', 'wc-viveum' );
		}

		return __( 'iDeal', 'wc-viveum' );
	}
}

$obj = new Gateway_Viveum_Ideal();
