<?php
/**
 * Viveum Klarna Pay later.
 *
 * The gateway is used for Klarna Pay later.
 * Copyright (c) Viveum
 *
 * @class      Gateway_Viveum_Klarnapaylater
 * @package    Viveum/Gateway
 * @extends    Viveum_Payment_Gateway
 * @located at /includes/gateways
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * The gateway is used for Klarna Pay later.
 */
class Gateway_Viveum_Klarnapaylater extends Viveum_Payment_Gateway {
	/**
	 * Identifier klarnapaylater
	 *
	 * @var string $id
	 */
	public $id = 'viveum_klarnapaylater';

	/**
	 * Payment type
	 *
	 * @var string $payment_type
	 */
	protected $payment_type = 'PA';

	/**
	 * Payment brand
	 *
	 * @var string $payment_brand
	 */
	protected $payment_brand = 'KLARNA_INVOICE';

	/**
	 * Get Payment Logo( s ) to get_icon()
	 *
	 * @return string
	 */
	public function viveum_get_payment_logo() {
		$logo = $this->plugins_url . '/assets/images/klarnapaylater.png';
		return $logo;
	}

	/**
	 * Get payment method backend configuration form fields
	 */
	public function get_backend_configuration_form_fields() {
		$form_fields = parent::get_backend_configuration_form_fields();
		$form_fields['enabled']['disabled'] = true;

		return $form_fields;
	}

	/**
	 * Get payment method title.
	 *
	 * @return string
	 */
	public function get_title() {
		if ( is_admin() ) {
			return __( 'Pay later.', 'wc-viveum' );
		}

		return __( 'Pay later.', 'wc-viveum' );
	}
}

$obj = new Gateway_Viveum_Klarnapaylater();
