<?php
/**
 * Viveum Klarna Slice it.
 *
 * The gateway is used for Klarna Slice it.
 * Copyright (c) Viveum
 *
 * @class      Gateway_Viveum_Klarnasliceit
 * @package    Viveum/Gateway
 * @extends    Viveum_Payment_Gateway
 * @located at /includes/gateways
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * The gateway is used for Klarna Slice it.
 */
class Gateway_Viveum_Klarnasliceit extends Viveum_Payment_Gateway {
	/**
	 * Identifier klarnasliceit
	 *
	 * @var string $id
	 */
	public $id = 'viveum_klarnasliceit';

	/**
	 * Payment type
	 *
	 * @var string $payment_type
	 */
	protected $payment_type = 'PA';

	/**
	 * Payment brand
	 *
	 * @var string $payment_brand
	 */
	protected $payment_brand = 'KLARNA_INSTALLMENTS';

	/**
	 * Get Payment Logo( s ) to get_icon()
	 *
	 * @return string
	 */
	public function viveum_get_payment_logo() {
		$logo = $this->plugins_url . '/assets/images/klarnasliceit.png';
		return $logo;
	}

	/**
	 * Get payment method backend configuration form fields
	 */
	public function get_backend_configuration_form_fields() {
		$form_fields = parent::get_backend_configuration_form_fields();
		$form_fields['enabled']['disabled'] = true;

		$form_fields['pclass'] = array(
			'title' => __( 'Installment Plan (PCLASS)', 'wc-viveum' ),
			'type' => 'text',
			'default' => '',
			'description' => __( 'Please insert your Klarna installment plan (PCLASS) here.', 'wc-viveum' ),
		);

		return $form_fields;
	}

	/**
	 * Get payment method title.
	 *
	 * @return string
	 */
	public function get_title() {
		if ( is_admin() ) {
			return __( 'Slice it.', 'wc-viveum' );
		}

		return __( 'Slice it.', 'wc-viveum' );
	}
}

$obj = new Gateway_Viveum_Klarnasliceit();
