<?php
/**
 * Viveum PayDirekt
 *
 * The gateway is used for PayDirekt.
 * Copyright (c) Viveum
 *
 * @class      Gateway_Viveum_PayDirekt
 * @package    Viveum/Gateway
 * @extends    Viveum_Payment_Gateway
 * @located at /includes/gateways
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * The gateway is used for PayDirekt.
 */
class Gateway_Viveum_Paydirekt extends Viveum_Payment_Gateway {
	/**
	 * Identifier paydirekt
	 *
	 * @var string $id
	 */
	public $id = 'viveum_paydirekt';

	/**
	 * Payment brand
	 *
	 * @var string $payment_brand
	 */
	protected $payment_brand = 'PAYDIREKT';

	/**
	 * Get Payment Logo( s ) to get_icon()
	 *
	 * @return string
	 */
	public function viveum_get_payment_logo() {
		return $this->plugins_url . '/assets/images/paydirekt.png';
	}

	/**
	 * Get payment method backend configuration form fields
	 */
	public function get_backend_configuration_form_fields() {
		$form_fields = parent::get_backend_configuration_form_fields();
		$form_fields['trans_mode'] = array(
			'title' => __( 'Transaction-Mode', 'wc-viveum' ),
			'css'   => 'padding: 1px;',
			'type' => 'select',
			'options' => array(
				'PA' => __( 'Pre-Authorization', 'wc-viveum' ),
				'DB' => __( 'Debit', 'wc-viveum' ),
			),
			'default' => 'PA',
		);
		$form_fields['minimum_age'] = array(
			'title' => __( 'Minimum Age', 'wc-viveum' ),
			'type' => 'text',
			'default' => '',
		);
		$form_fields['payment_is_partial']  = array(
			'title' => __( 'Partial Capture or Refund', 'wc-viveum' ),
			'css'   => 'padding: 1px;',
			'type' => 'select',
			'options' => array(
				'true' => __( 'Yes', 'wc-viveum' ),
				'false' => __( 'No', 'wc-viveum' ),
			),
			'default' => 'false',
		);

		return $form_fields;
	}

	/**
	 * Get payment method title.
	 *
	 * @return string
	 */
	public function get_title() {
		if ( is_admin() ) {
			return __( 'paydirekt', 'wc-viveum' );
		}

		return __( 'paydirekt', 'wc-viveum' );
	}
}

$obj = new Gateway_Viveum_Paydirekt();
