<?php
/**
 * Viveum PaypPal
 *
 * The gateway is used for PaypPal.
 * Copyright (c) Viveum
 *
 * @class      Gateway_Viveum_Paypal
 * @package    Viveum/Gateway
 * @extends    Viveum_Payment_Gateway
 * @located at /includes/gateways
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * The gateway is used for PaypPal.
 */
class Gateway_Viveum_Paypal extends Viveum_Payment_Gateway {
	/**
	 * Identifier paypal
	 *
	 * @var string $id
	 */
	public $id = 'viveum_paypal';

	/**
	 * Payment brand
	 *
	 * @var string $payment_brand
	 */
	protected $payment_brand = 'PAYPAL';

	/**
	 * Get Payment Logo( s ) to get_icon()
	 *
	 * @return string
	 */
	public function viveum_get_payment_logo() {
		return $this->plugins_url . '/assets/images/paypal.png';
	}

	/**
	 * Get payment method title.
	 *
	 * @return string
	 */
	public function get_title() {
		if ( is_admin() ) {
			return __( 'PayPal', 'wc-viveum' );
		}

		return __( 'PayPal', 'wc-viveum' );
	}
}

$obj = new Gateway_Viveum_Paypal();
