<?php
/**
 * Viveum PaypPal Recurring
 *
 * The gateway is used for PaypPal Recurring.
 * Copyright (c) Viveum
 *
 * @class      Gateway_Viveum_PaypalSaved
 * @package    Viveum/Gateway
 * @extends    Viveum_Payment_Gateway
 * @located at /includes/gateways
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * The gateway is used for PaypPal Recurring.
 */
class Gateway_Viveum_PaypalSaved extends Gateway_Viveum_Paypal {
	/**
	 * Identifier paypal
	 *
	 * @var string $id
	 */
	public $id = 'viveum_paypalsaved';

	/**
	 * Payment group
	 *
	 * @var string $payment_group
	 */
	protected $payment_group = 'PAYPAL';
	/**
	 * Is recurring
	 *
	 * @var bool $is_recurring
	 */
	protected $is_recurring = true;

	
	public function __construct() 
    {
        parent::__construct();

		// Check if subscriptions are enabled and add support for them.
		$this->maybe_init_subscriptions();
    }

	/**
	 * Get payment method backend configuration form fields
	 */
	public function get_backend_configuration_form_fields() {
		$form_fields = parent::get_backend_configuration_form_fields();
		$form_fields['amount_registration'] = array(
			'title' => __( 'Amount for Registration', 'wc-viveum' ),
			'type' => 'text',
			'default' => '',
			'description' => __( 'Amount that is debited and refunded when a shopper registers a payment method without purchase', 'wc-viveum' ),
		);

		return $form_fields;
	}

	/**
	 * Get payment method title.
	 *
	 * @return string
	 */
	public function get_title() {
		if ( is_admin() ) {
			return __( 'PayPal (Recurring)', 'wc-viveum' );
		}

		return __( 'PayPal', 'wc-viveum' );
	}
}

$obj = new Gateway_Viveum_PaypalSaved();
