<?php
/**
 * Viveum Swisspostfinance
 *
 * The gateway is used for Swisspostfinance.
 * Copyright (c) Viveum
 *
 * @class      Gateway_Viveum_Swisspostfinance
 * @package    Viveum/Gateway
 * @extends    Viveum_Payment_Gateway
 * @located at /includes/gateways
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * The gateway is used for Swisspostfinance.
 */
class Gateway_Viveum_Swisspostfinance extends Viveum_Payment_Gateway {
	/**
	 * Identifier swisspostfinance
	 *
	 * @var string $id
	 */
	public $id = 'viveum_swisspostfinance';

	/**
	 * Get Payment Logo( s ) to get_icon()
	 *
	 * @return string
	 */
	public function viveum_get_payment_logo() {
		return $this->plugins_url . '/assets/images/swisspostfinance.png';
	}

	/**
	 * Get payment method title.
	 *
	 * @return string
	 */
	public function get_title() {
		if ( is_admin() ) {
			return __( 'SwissPostFinance', 'wc-viveum' );
		}

		return __( 'SwissPostFinance', 'wc-viveum' );
	}
}

$obj = new Gateway_Viveum_Swisspostfinance();
