<?php
/**
 * Viveum Payments Form
 *
 * The file is for displaying the Viveum payment form
 * Copyright (c) Viveum
 *
 * @package     Viveum/Templates
 * @located at  /template/ckeckout/
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}
?>

<script type="text/javascript">
	var wpwlOptions = {
		applePay: {
			displayName: "<?php echo $settings['shop_name']; ?>",
			total: {
				label: "<?php echo $settings['shop_name']; ?>",
			},
			merchantIdentifier: "<?php echo $settings['applepay_merchant_id']; ?>",
			supportedNetworks: <?php echo "['" . implode( "', '", $settings['card_types'] ) . "']"; ?>,
			style: "<?php echo $settings['button_style']; ?>",
			onCancel: function(errorCode) {
				window.location = "<?php echo esc_attr( $url_config['cancel_url'] ) ?>";
			},
		},

		locale: "<?php echo esc_attr( strtolower( substr( get_bloginfo( 'language' ), 0, 2 ) ) ) ?>",
		style: "card",
		onReady: function() {
			var buttonCancel = "<a href='<?php echo esc_attr( $url_config['cancel_url'] ) ?>' class='wpwl-button btn_cancel'><?php echo esc_attr( __( 'Cancel', 'wc-viveum' ) ) ?></a>";
			jQuery( "form.wpwl-form" ).find( ".gpay-card-info-container" ).before( buttonCancel );
			<?php if ( 'TEST' === $settings['server_mode'] ) : ?>
				var ttTestMode = "<div class='testmode'><?php echo esc_attr( __( 'THIS IS A TEST. NO REAL MONEY WILL BE TRANSFERED', 'wc-viveum' ) ) ?></div>";
				jQuery( ".wpwl-container" ).wrap( "<div class='frametest'></div>" );
				jQuery( ".wpwl-container" ).before( ttTestMode );
			<?php endif; ?>
		},
		registrations: {
			hideInitialPaymentForms: false,
			requireCvv: false
		}
	}
</script>
<?php echo $payment_widget_script;?>
<form action="<?php echo esc_attr( $url_config['return_url'] ) ?>" class="paymentWidgets" data-brands="<?php echo esc_attr( $payment_parameters['payment_brand'] ) ?>"></form>
