<?php
/**
 * Viveum Plugin Additional
 *
 * This file is used for add payment status, extra customer info.
 * Copyright (c) Viveum
 *
 * @package Viveum
 * @located at  /
 */

/**
 * Register new order statuses
 *  ( In Review, Pre-Authorization and Payment Accepted )
 */
function register_payment_status() {

	register_post_status( 'wc-in-review', array(
		'label'                     => _x( 'In Review', 'WooCommerce Order Status', 'wc_viveum' ),
		'public'                    => true,
		'exclude_from_search'       => false,
		'show_in_admin_all_list'    => true,
		'show_in_admin_status_list' => true,
		/* translators: %s: https://developer.wordpress.org/rest-api/  */
		'label_count'               => _n_noop( 'In Review ( %s )', 'In Review ( %s )', 'wc_viveum' ),
	) );

	register_post_status( 'wc-pre-authorization', array(
		'label'                     => _x( 'Pre-Authorization', 'WooCommerce Order Status', 'wc_viveum' ),
		'public'                    => true,
		'exclude_from_search'       => false,
		'show_in_admin_all_list'    => true,
		'show_in_admin_status_list' => true,
		/* translators: %s: https://developer.wordpress.org/rest-api/  */
		'label_count'               => _n_noop( 'Pre-Authorization ( %s )', 'Pre-Authorization ( %s )', 'wc_viveum' ),
	) );

	register_post_status( 'wc-payment-accepted', array(
		'label'                     => _x( 'Payment Accepted', 'WooCommerce Order Status', 'wc_viveum' ),
		'public'                    => true,
		'exclude_from_search'       => false,
		'show_in_admin_all_list'    => true,
		'show_in_admin_status_list' => true,
		/* translators: %s: https://developer.wordpress.org/rest-api/  */
		'label_count'               => _n_noop( 'Payment Accepted ( %s )', __( 'Payment Accepted ( %s )', 'wc-viveum' ), 'wc_viveum' ),
	) );

}
add_filter( 'init', 'register_payment_status' );

/**
 * Add new order statuses to woocommerce
 *  ( In Review, Pre-Authorization and Payment Accepted )
 *
 * @param array $order_status order status.
 */
function add_order_status( $order_status ) {
	$order_status['wc-in-review'] = _x( __( 'In Review', 'wc-viveum' ), 'In Review Order Status', 'wc_viveum' );
	$order_status['wc-pre-authorization'] = _x( 'Pre-Authorization', 'Pre-authorization Order Status', 'wc_viveum' );
	$order_status['wc-payment-accepted'] = _x( __( 'Payment Accepted', 'wc-viveum' ), 'Payment Accepted Order Status', 'wc_viveum' );

	return $order_status;
}
add_filter( 'wc_order_statuses', 'add_order_status' );

/**
 * Add extra profile info at user profile
 *  ( Date of birth and Gender )
 *
 * @param array $user user.
 */
function add_extra_user_profile_fields( $user ) {
	$dob = esc_attr( get_the_author_meta( 'viveum_billing_dob', $user->ID ) );
	$gender = esc_attr( get_the_author_meta( 'viveum_billing_gender', $user->ID ) );

	$label = array(
		'costumer' => __( 'Customer', 'wc-viveum' ),
		'dob' => __( 'Date of Birth', 'wc-viveum' ),
		'gender' => __( 'Gender', 'wc-viveum' ),
		'gender_male' => __( 'Male', 'wc-viveum' ),
		'gender_female' => __( 'Female', 'wc-viveum' ),
		'dob_placeholder' => __( 'DD.MM.YYYY', 'wc-viveum' ),
	);

	$args = array(
		'dob' => $dob,
		'gender' => $gender,
		'label' => $label,
	);
	Viveum_General_Functions::viveum_include_template( dirname( __FILE__ ) . '/templates/admin/user/template-edit-user.php', $args );
}
if ( get_option( 'viveum_general_dob_gender' ) ) {
	add_action( 'show_user_profile', 'add_extra_user_profile_fields' );
	add_action( 'edit_user_profile', 'add_extra_user_profile_fields' );
}

/**
 * Save extra profile info at user profile
 *  ( Date of birth and Gender )
 *
 * @param array $user_id user id.
 * @return bool
 */
function save_extra_user_profile_fields( $user_id ) {
	$saved = false;
	if ( current_user_can( 'edit_user', $user_id ) ) {
		$billing_dob = Viveum_General_Functions::viveum_get_request_value( 'viveum_billing_dob', '00-00-0000' );
		update_user_meta( $user_id, 'viveum_billing_dob', $billing_dob );
		$billing_gender = Viveum_General_Functions::viveum_get_request_value( 'viveum_billing_gender', 'Male' );
		update_user_meta( $user_id, 'viveum_billing_gender', $billing_gender );
		$saved = true;
	}
	return true;
}
if ( get_option( 'viveum_general_dob_gender' ) ) {
	add_action( 'personal_options_update', 'save_extra_user_profile_fields' );
	add_action( 'edit_user_profile_update', 'save_extra_user_profile_fields' );
}

/**
 * Add date of birth & gender at user profile
 *
 * @param array $fields fields.
 * @return bool
 */
function custom_woocommerce_billing_fields( $fields ) {

	$label = array(
		'dob' => __( 'Date of Birth', 'wc-viveum' ),
		'gender' => __( 'Gender', 'wc-viveum' ),
		'dob_placeholder' => __( 'DD.MM.YYYY', 'wc-viveum' ),
	);

	$fields['viveum_billing_dob'] = array(
		'type'          => 'text',
		'label'         => $label['dob'],
		'required'      => true,
		'placeholder'   => $label['dob_placeholder'],
		'class'         => array( 'form-row-first', 'address-field' ),
		'priority'		=> '120',
	);

	$fields['viveum_billing_gender'] = array(
		'type'      => 'select',
		'label'     => $label['gender'],
		'options'   => array(
			'Male' => __( 'Male', 'wc-viveum' ),
			'Female' => __( 'Female', 'wc-viveum' ),
		),
		'required'  => true,
		'class'     => array( 'form-row-last', 'address-field' ),
		'clear'     => true,
		'priority'	=> '130',
	);

	return $fields;
}
if ( get_option( 'viveum_general_dob_gender' ) ) {
	add_filter( 'woocommerce_billing_fields', 'custom_woocommerce_billing_fields' );
}

/**
 * Save date of birth and gender after ajax load payment method list
 *
 * @param  string $post_data post data.
 */
function action_checkout_update_order_review( $post_data ) {
	parse_str( $post_data, $output );
	WC()->session->set( 'viveum_billing_dob', $output['viveum_billing_dob'] );
	WC()->session->set( 'viveum_billing_gender', $output['viveum_billing_gender'] );
}
if ( get_option( 'viveum_general_dob_gender' ) ) {
	add_action( 'woocommerce_checkout_update_order_review', 'action_checkout_update_order_review' );
}

/**
 * Add Viveum custom order status icon
 */
function viveum_add_custom_order_status_icon() {
	if ( ! is_admin() ) {
		return;
	}
	?>
		<style>
			.column-order_status mark.pre-authorization:after, .column-order_status mark.payment-accepted:after, .column-order_status mark.in-review:after {
				background-size:100%;
				position: absolute;
				top: 0;
				left: 0;
				width: 100%;
				height: 100%;
				text-align: center;
				content: '';
				background-repeat: no-repeat;
			}
			.column-order_status mark.pre-authorization:after {
				background-image: url(<?php echo esc_attr( plugins_url( 'assets/images/pre-authorization.png', __FILE__ ) ); ?>);
			}
			.column-order_status mark.payment-accepted:after {
				background-image: url(<?php echo esc_attr( plugins_url( 'assets/images/payment-accepted.png', __FILE__ ) ); ?>);
			}
			.column-order_status mark.in-review:after {
				background-image: url(<?php echo esc_attr( plugins_url( 'assets/images/in-review.png', __FILE__ ) ); ?>);
			}
		</style>
	<?php
}

add_action( 'wp_print_scripts', 'viveum_add_custom_order_status_icon' );

/**
 * Change placeholder on address field in checkout page
 *
 * @param array $fields fields.
 * @return array
 */
function viveum_label_wc_address_field( $fields ) {
	$label = array(
		'address_2_placeholder' => __( 'Apartment, suite, unit etc. (optional)', 'wc-viveum' ),
	);

	$fields['address_2']['placeholder'] = $label['address_2_placeholder'];

	return $fields;
}
add_filter( 'woocommerce_default_address_fields', 'viveum_label_wc_address_field' );
