<?php
/**
 * Viveum Credit Card Recurring
 *
 * The gateway is used for Credit card Recurring.
 * Copyright (c) Viveum
 *
 * @class      Gateway_Viveum_CCSaved
 * @package    Viveum/Gateway
 * @extends    Viveum_Payment_Gateway
 * @located at /includes/gateways
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * The gateway is used for Credit card Recurring.
 */
class Gateway_Viveum_CCSaved extends Gateway_Viveum_CC {

	/**
	 * Identifier CC
	 *
	 * @var string $id
	 */
	public $id = 'viveum_ccsaved';

	/**
	 * Payment group
	 *
	 * @var string $payment_group
	 */
	protected $payment_group = 'CC';

	/**
	 * Is recurring
	 *
	 * @var bool $is_recurring
	 */
	protected $is_recurring = true;


	public function __construct() 
    {
        parent::__construct();

		// Check if subscriptions are enabled and add support for them.
		$this->maybe_init_subscriptions();
    }

	/**
	 * Get payment method backend configuration form fields
	 */
	public function get_backend_configuration_form_fields() {
		$form_fields = parent::get_backend_configuration_form_fields();
		$form_fields['amount_registration'] = array(
			'title' => __( 'Amount for Registration', 'wc-viveum' ),
			'type' => 'text',
			'default' => '',
			'description' => __( 'Amount that is debited and refunded when a shopper registers a payment method without purchase', 'wc-viveum' ),
		);
		$form_fields['multichannel'] = array(
			'title' => __( 'Multichannel', 'wc-viveum' ),
			'css'   => 'padding: 1px;',
			'type' => 'select',
			'options' => array(
				true => __( 'Yes', 'wc-viveum' ),
				false => __( 'No', 'wc-viveum' ),
			),
			'default' => 0,
			'description' => __( 'If activated, repeated recurring payments are handled by the alternative channel', 'wc-viveum' ),
		);
		$form_fields['channel_moto'] = array(
			'title' => __( 'Entity-ID MOTO', 'wc-viveum' ),
			'type' => 'text',
			'default' => '',
			'description' => __( 'Alternative channel for recurring payments if Multichannel is activated (to bypass 3D Secure)', 'wc-viveum' ),
		);

		return $form_fields;
	}

	/**
	 * Get payment method title.
	 *
	 * @return string
	 */
	public function get_title() {
		if ( is_admin() ) {
			return __( 'Credit Cards (Recurring)', 'wc-viveum' );
		}

		return __( 'Credit Cards', 'wc-viveum' );
	}
}

$obj = new Gateway_Viveum_CCSaved();
