<?php
/**
 * Viveum Debit Card
 *
 * The gateway is used for Debit Card.
 * Copyright (c) Viveum
 *
 * @class      Gateway_Viveum_DC
 * @package    Viveum/Gateway
 * @extends    Viveum_Payment_Gateway
 * @located at /includes/gateways
 */

if ( ! defined( 'ABSPATH' ) ) {
	exit; // Exit if accessed directly.
}

/**
 * The gateway is used for Debit Card.
 */
class Gateway_Viveum_DC extends Viveum_Payment_Gateway {
	/**
	 * Identifier DC
	 *
	 * @var string $id
	 */
	public $id = 'viveum_dc';

	/**
	 * From class WC_Payment_Gateway
	 * Payment gateway icon.
	 */
	public function get_icon() {
		$icon_html = $this->viveum_get_multi_icon();
		return apply_filters( 'woocommerce_gateway_icon', $icon_html, $this->id );
	}

	/**
	 * Get payment method title.
	 *
	 * @return string
	 */
	public function get_title() {
		if ( is_admin() ) {
			return __( 'Debit Cards', 'wc-viveum' );
		}

		return __( 'Debit Cards', 'wc-viveum' );
	}

}

$obj = new Gateway_Viveum_DC();
